/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.server.core.builtin.IPHPRuntimeWorkingCopy;
import org.eclipse.php.internal.server.core.builtin.Messages;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class PHPRuntime
extends RuntimeDelegate
implements IPHPRuntimeWorkingCopy {
    protected static final String PROP_EXECUTABLE_INSTALL_NAME = "executable-install-name";
    private PHPexeItem exeItem;

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        File f = this.getRuntime().getLocation().toFile();
        if (!f.canRead()) {
            return new Status(2, "org.eclipse.php.server.core", 0, Messages.warningCantReadDirectory, null);
        }
        PHPexeItem installedItem = this.getExecutableInstall();
        if (!installedItem.getSapiType().equals("CLI")) {
            return new Status(4, "org.eclipse.php.server.core", 0, "Only the CLI SAPI provides a built-in web server", null);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void setExecutableInstall(PHPexeItem item) {
        if (item == null) {
            this.internalSetExecutableInstall(null);
        } else {
            this.internalSetExecutableInstall(item.getName());
        }
        this.exeItem = item;
    }

    private void internalSetExecutableInstall(String name) {
        if (name == null) {
            this.setAttribute(PROP_EXECUTABLE_INSTALL_NAME, null);
        } else {
            this.setAttribute(PROP_EXECUTABLE_INSTALL_NAME, name);
        }
    }

    @Override
    public PHPexeItem getExecutableInstall() {
        if (this.exeItem != null) {
            return this.exeItem;
        }
        if (this.getExecutableInstallName() == null) {
            return null;
        }
        try {
            String name = this.getExecutableInstallName();
            return PHPexes.getInstance().getItem(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getExecutableInstallName() {
        return this.getAttribute(PROP_EXECUTABLE_INSTALL_NAME, null);
    }
}

