/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.core;

import java.net.Proxy;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.core.ExtensionPointReader;
import org.eclipse.mylyn.commons.core.net.NetUtil;
import org.eclipse.mylyn.commons.core.net.ProxyProvider;
import org.eclipse.mylyn.commons.repositories.core.ILocationService;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.InMemoryCredentialsStore;

public class LocationService
implements ILocationService {
    private final ProxyProvider proxyProvider;

    public static ILocationService getDefault() {
        return LocationServiceInitializer.service;
    }

    public LocationService() {
        this(PlatformProxyProvider.INSTANCE);
    }

    public LocationService(ProxyProvider proxyProvider) {
        this.proxyProvider = proxyProvider;
    }

    @Override
    public ICredentialsStore getCredentialsStore(String id) {
        return InMemoryCredentialsStore.getStore(id);
    }

    @Override
    public Proxy getProxyForHost(String host, String proxyType) {
        if (this.proxyProvider != null) {
            return this.proxyProvider.getProxyForHost(host, proxyType);
        }
        return null;
    }

    @Override
    public X509TrustManager getTrustManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends AuthenticationCredentials> T requestCredentials(AuthenticationRequest<AuthenticationType<T>> context, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    static class LocationServiceInitializer {
        private static ILocationService service;

        static {
            ExtensionPointReader reader = new ExtensionPointReader("org.eclipse.mylyn.commons.repositories.core", "locationServices", "service", ILocationService.class);
            reader.read();
            service = reader.getItem() != null ? (ILocationService)reader.getItem() : new LocationService();
        }

        LocationServiceInitializer() {
        }
    }

    private static class PlatformProxyProvider
    extends ProxyProvider {
        static PlatformProxyProvider INSTANCE = new PlatformProxyProvider();

        private PlatformProxyProvider() {
        }

        public Proxy getProxyForHost(String host, String proxyType) {
            return NetUtil.getProxy((String)host, (String)proxyType);
        }
    }
}

