/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;

public class GitFlowConfig {
    public static final String MASTER_KEY = "master";
    public static final String DEVELOP_KEY = "develop";
    public static final String HOTFIX_KEY = "hotfix";
    public static final String RELEASE_KEY = "release";
    public static final String FEATURE_KEY = "feature";
    public static final String VERSION_TAG_KEY = "versiontag";
    public static final String USER_SECTION = "user";
    public static final String BRANCH_SECTION = "branch";
    public static final String PREFIX_SECTION = "prefix";
    public static final String GITFLOW_SECTION = "gitflow";
    public static final String REMOTE_KEY = "remote";
    public static final String MERGE_KEY = "merge";
    private Repository repository;

    public GitFlowConfig(Repository repository) {
        Assert.isNotNull((Object)repository);
        this.repository = repository;
    }

    public boolean isInitialized() throws IOException {
        StoredConfig config = this.repository.getConfig();
        Set sections = config.getSections();
        return sections.contains(GITFLOW_SECTION);
    }

    public String getUser() {
        StoredConfig config = this.repository.getConfig();
        String userName = config.getString(USER_SECTION, null, "name");
        String email = config.getString(USER_SECTION, null, "email");
        return String.format("%s <%s>", userName, email);
    }

    public String getFeaturePrefix() {
        return this.getPrefix(FEATURE_KEY, "feature/");
    }

    public String getReleasePrefix() {
        return this.getPrefix(RELEASE_KEY, "release/");
    }

    public String getHotfixPrefix() {
        return this.getPrefix(HOTFIX_KEY, "hotfix/");
    }

    public String getVersionTagPrefix() {
        return this.getPrefix(VERSION_TAG_KEY, "");
    }

    public String getDevelop() {
        return this.getBranch(DEVELOP_KEY, DEVELOP_KEY);
    }

    public String getDevelopFull() {
        return "refs/heads/" + this.getDevelop();
    }

    public String getMaster() {
        return this.getBranch(MASTER_KEY, MASTER_KEY);
    }

    public String getPrefix(String prefixName, String defaultPrefix) {
        StoredConfig config = this.repository.getConfig();
        String result = config.getString(GITFLOW_SECTION, PREFIX_SECTION, prefixName);
        return result == null ? defaultPrefix : result;
    }

    public String getBranch(String branch, String defaultBranch) {
        StoredConfig config = this.repository.getConfig();
        String result = config.getString(GITFLOW_SECTION, BRANCH_SECTION, branch);
        return result == null ? defaultBranch : result;
    }

    public void setPrefix(String prefixName, String value) {
        StoredConfig config = this.repository.getConfig();
        config.setString(GITFLOW_SECTION, PREFIX_SECTION, prefixName, value);
    }

    public void setBranch(String branchName, String value) {
        StoredConfig config = this.repository.getConfig();
        config.setString(GITFLOW_SECTION, BRANCH_SECTION, branchName, value);
    }

    public String getFullFeatureBranchName(String featureName) {
        return "refs/heads/" + this.getFeatureBranchName(featureName);
    }

    public String getFeatureBranchName(String featureName) {
        return String.valueOf(this.getFeaturePrefix()) + featureName;
    }

    public String getHotfixBranchName(String hotfixName) {
        return String.valueOf(this.getHotfixPrefix()) + hotfixName;
    }

    public String getFullHotfixBranchName(String hotfixName) {
        return "refs/heads/" + this.getHotfixBranchName(hotfixName);
    }

    public String getFullReleaseBranchName(String releaseName) {
        return "refs/heads/" + this.getReleaseBranchName(releaseName);
    }

    public String getReleaseBranchName(String releaseName) {
        return String.valueOf(this.getReleasePrefix()) + releaseName;
    }

    public RemoteConfig getDefaultRemoteConfig() {
        RemoteConfig result;
        StoredConfig rc = this.repository.getConfig();
        try {
            result = new RemoteConfig((Config)rc, "origin");
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public boolean hasDefaultRemote() {
        RemoteConfig config = this.getDefaultRemoteConfig();
        return !config.getURIs().isEmpty();
    }

    public void setRemote(String featureName, String value) throws IOException {
        this.setBranchValue(featureName, value, REMOTE_KEY);
    }

    public void setUpstreamBranchName(String featureName, String value) throws IOException {
        this.setBranchValue(featureName, value, MERGE_KEY);
    }

    public String getUpstreamBranchName(String featureName) {
        StoredConfig config = this.repository.getConfig();
        return config.getString(BRANCH_SECTION, this.getFeatureBranchName(featureName), MERGE_KEY);
    }

    private void setBranchValue(String featureName, String value, String mergeKey) throws IOException {
        StoredConfig config = this.repository.getConfig();
        config.setString(BRANCH_SECTION, featureName, mergeKey, value);
        config.save();
    }

    public String getRemoteName(String featureName) {
        StoredConfig config = this.repository.getConfig();
        return config.getString(BRANCH_SECTION, this.getFeatureBranchName(featureName), REMOTE_KEY);
    }
}

