/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename.logic;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.core.ast.nodes.Dispatch;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldAccess;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.MethodInvocation;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.StaticDispatch;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.ast.nodes.TraitAlias;
import org.eclipse.php.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.RefactoringPlugin;
import org.eclipse.php.refactoring.core.rename.logic.AbstractRename;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;

public class RenameClassMember
extends AbstractRename {
    private int nodeType;
    private static final String RENAME_CLASS_MEMBER = PHPRefactoringCoreMessages.getString("RenameClassPropertyName.0");
    private ITypeBinding type;
    private List<IType> traitList;
    private List<IType> traitListIncludingSuperClass;
    private Boolean isTraitMethod;

    public RenameClassMember(IFile file, String oldName, String newName, boolean searchTextual, int type) {
        super(file, oldName, newName, searchTextual);
        this.nodeType = type;
    }

    public RenameClassMember(IFile file, String oldName, String newName, boolean searchTextual, ITypeBinding iTypeBinding, int type, ASTNode identifier) {
        this(file, oldName, newName, searchTextual, type);
        this.type = iTypeBinding;
        PHPVersion phpVersion = PHPVersion.PHP5_4;
        if (file.getProject() != null) {
            phpVersion = ProjectOptions.getPHPVersion((IProject)file.getProject());
        }
        if (iTypeBinding != null && phpVersion.isGreaterThan(PHPVersion.PHP5_3)) {
            String memberName = oldName;
            if (identifier instanceof Identifier && (identifier.getParent().getType() == 74 || identifier.getParent().getType() == 73)) {
                memberName = this.getRealName(identifier);
            }
            this.isTraitMethod = this.isTraitMethod(iTypeBinding, memberName);
            this.traitList = iTypeBinding.getTraitList(this.isTraitMethod.booleanValue(), memberName, false);
            this.traitListIncludingSuperClass = iTypeBinding.getTraitList(this.isTraitMethod.booleanValue(), memberName, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTraitMethod(ITypeBinding typeBinding, String memberName) {
        if (typeBinding == null) return this.isChangeMethod();
        if (!typeBinding.isTrait()) return this.isChangeMethod();
        if (typeBinding.getPHPElement() == null) return this.isChangeMethod();
        try {
            IModelElement[] members;
            IModelElement[] iModelElementArray = members = ((IType)typeBinding.getPHPElement()).getChildren();
            int n = members.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return this.isChangeMethod();
                }
                IModelElement modelElement = iModelElementArray[n2];
                if (modelElement.getElementName().equals(memberName)) {
                    if (!(modelElement instanceof IMethod)) return false;
                    return true;
                }
                ++n2;
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return this.isChangeMethod();
    }

    private String getRealName(ASTNode node) {
        TraitAlias traitAlias;
        Identifier identifier;
        String memberName = this.oldName;
        if (node instanceof Identifier && (identifier = (Identifier)node).getParent().getType() == 74 && identifier == (traitAlias = (TraitAlias)identifier.getParent()).getFunctionName()) {
            Expression expression = traitAlias.getTraitMethod();
            if (expression.getType() == 73) {
                FullyQualifiedTraitMethodReference fqtm = (FullyQualifiedTraitMethodReference)expression;
                memberName = fqtm.getFunctionName().getName();
            } else {
                memberName = ((Identifier)expression).getName();
            }
        }
        return memberName;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        if (this.isChangeMethod()) {
            try {
                Identifier identifier = methodDeclaration.getFunction().getFunctionName();
                if (!identifier.getName().equals(this.oldName) || methodDeclaration.resolveMethodBinding() == null) {
                    return super.visit(methodDeclaration);
                }
                ITypeBinding declClass = methodDeclaration.resolveMethodBinding().getDeclaringClass();
                if (declClass != null) {
                    if (declClass.equals((Object)this.type) || this.traitEqual(declClass, (ASTNode)identifier)) {
                        this.addChange(identifier.getStart());
                    } else if (this.type != null && (declClass.isSubTypeCompatible(this.type) || this.type.isSubTypeCompatible(declClass))) {
                        if (methodDeclaration.getModifier() != 16) {
                            this.addChange(identifier.getStart());
                        }
                    } else if (this.traitInSuperEqual(declClass, (ASTNode)identifier)) {
                        this.addChange(identifier.getStart());
                    }
                }
            }
            catch (Exception e) {
                RefactoringPlugin.logException(e);
            }
        }
        return super.visit(methodDeclaration);
    }

    private boolean traitEqual(ITypeBinding declClass, ASTNode node) {
        if (declClass != null && this.traitList != null && !this.traitList.isEmpty()) {
            if (node instanceof Variable) {
                node = this.getIdentifer((Variable)node);
            }
            if (node instanceof Identifier) {
                Identifier identifier = (Identifier)node;
                String memberName = this.getRealName((ASTNode)identifier);
                List traitList1 = declClass.getTraitList(this.isChangeMethod(), memberName, false);
                for (IType trait1 : traitList1) {
                    for (IType trait : this.traitList) {
                        if (!trait1.equals(trait)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean traitInSuperEqual(ITypeBinding declClass, ASTNode node) {
        if (declClass != null && this.traitListIncludingSuperClass != null && !this.traitListIncludingSuperClass.isEmpty()) {
            if (node instanceof Variable) {
                node = this.getIdentifer((Variable)node);
            }
            if (node instanceof Identifier) {
                Identifier identifier = (Identifier)node;
                String memberName = this.getRealName((ASTNode)identifier);
                List traitList1 = declClass.getTraitList(this.isChangeMethod(), memberName, true);
                for (IType trait1 : traitList1) {
                    for (IType trait : this.traitListIncludingSuperClass) {
                        if (!trait1.equals(trait)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isChangeMethod() {
        return this.nodeType == 42 || this.nodeType == 29 || this.nodeType == 31 || this.isTraitMethod != null && this.isTraitMethod != false;
    }

    public boolean visit(ConstantDeclaration classConstantDeclaration) {
        if (this.isChangeConstant()) {
            List variableNames = classConstantDeclaration.names();
            int j = 0;
            while (j < variableNames.size()) {
                assert (variableNames.get(j) instanceof Identifier);
                Identifier variable = (Identifier)variableNames.get(j);
                this.handleIdentifier(variable);
                ++j;
            }
        }
        return super.visit(classConstantDeclaration);
    }

    private boolean isChangeConstant() {
        return this.nodeType == 10 || this.nodeType == 11 || this.isTraitMethod != null && this.isTraitMethod == false;
    }

    public boolean visit(FieldsDeclaration fieldsDeclaration) {
        if (this.isChangeField()) {
            TypeDeclaration typeDecl = RefactoringUtility.getType((ASTNode)fieldsDeclaration);
            ITypeBinding declClass = null;
            if (typeDecl != null) {
                declClass = typeDecl.resolveTypeBinding();
            }
            if (declClass != null) {
                Variable[] variableNames = fieldsDeclaration.getVariableNames();
                int j = 0;
                while (j < variableNames.length) {
                    Identifier variable;
                    if (declClass.equals((Object)this.type) || this.traitEqual(declClass, (ASTNode)variableNames[j].getName())) {
                        assert (variableNames[j].getName() instanceof Identifier);
                        variable = (Identifier)variableNames[j].getName();
                        this.handleIdentifier(variable);
                    } else if (this.type != null && (declClass.isSubTypeCompatible(this.type) || this.type.isSubTypeCompatible(declClass))) {
                        if (fieldsDeclaration.getModifier() != 16) {
                            variable = (Identifier)variableNames[j].getName();
                            this.handleIdentifier(variable);
                        }
                    } else if (this.traitInSuperEqual(declClass, (ASTNode)((Identifier)variableNames[j].getName()))) {
                        variable = (Identifier)variableNames[j].getName();
                        this.handleIdentifier(variable);
                    }
                    ++j;
                }
            }
        }
        return super.visit(fieldsDeclaration);
    }

    private boolean isChangeField() {
        return this.nodeType == 25 || this.nodeType == 60 || this.isTraitMethod != null && this.isTraitMethod == false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        ITypeBinding declClass;
        if (this.isChangeMethod() && methodInvocation.getDispatcher() != null && (declClass = methodInvocation.getDispatcher().resolveTypeBinding()) != null) {
            if (declClass.equals((Object)this.type) || this.traitEqual(declClass, (ASTNode)methodInvocation.getMethod().getFunctionName().getName())) {
                this.handleDispatch((Dispatch)methodInvocation);
            } else if (this.type != null && (declClass.isSubTypeCompatible(this.type) || this.type.isSubTypeCompatible(declClass))) {
                IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                if (methodBinding != null && methodBinding.getModifiers() != 16) {
                    this.handleDispatch((Dispatch)methodInvocation);
                }
            } else if (this.traitInSuperEqual(declClass, (ASTNode)methodInvocation.getMethod().getFunctionName().getName())) {
                this.handleDispatch((Dispatch)methodInvocation);
            }
        }
        return super.visit(methodInvocation);
    }

    private void handleDispatch(Dispatch dispatch) {
        VariableBase variable = dispatch.getMember();
        Identifier identifier = null;
        if (variable instanceof Variable) {
            identifier = this.getIdentifer((Variable)variable);
        }
        if (variable instanceof FunctionInvocation) {
            Variable functionName = (Variable)((FunctionInvocation)variable).getFunctionName().getName();
            identifier = this.getIdentifer(functionName);
        }
        if (identifier != null && identifier.getName().equals(this.oldName)) {
            this.addChange(identifier.getStart());
        }
    }

    private Identifier getIdentifer(Variable node) {
        Expression temp = node.getName();
        while (temp != null && !(temp instanceof Identifier)) {
            if (temp instanceof Variable) {
                temp = ((Variable)temp).getName();
                continue;
            }
            return null;
        }
        return (Identifier)temp;
    }

    private void handleIdentifier(Identifier identifier) {
        if (identifier.getName().equals(this.oldName)) {
            this.addChange(identifier.getStart());
        }
    }

    public boolean visit(FieldAccess fieldAccess) {
        ITypeBinding declClass;
        if (this.isChangeField() && (declClass = fieldAccess.getDispatcher().resolveTypeBinding()) != null) {
            if (declClass.equals((Object)this.type) || this.traitEqual(declClass, (ASTNode)fieldAccess.getMember())) {
                this.handleDispatch((Dispatch)fieldAccess);
            } else if (this.type != null && (declClass.isSubTypeCompatible(this.type) || this.type.isSubTypeCompatible(declClass))) {
                IVariableBinding binding = fieldAccess.resolveFieldBinding();
                if (binding != null && binding.getModifiers() != 16) {
                    this.handleDispatch((Dispatch)fieldAccess);
                }
            } else if (this.traitInSuperEqual(declClass, (ASTNode)fieldAccess.getMember())) {
                this.handleDispatch((Dispatch)fieldAccess);
            }
        }
        return super.visit(fieldAccess);
    }

    public boolean visit(StaticConstantAccess classConstantAccess) {
        this.handlStaticDispatch((StaticDispatch)classConstantAccess);
        return super.visit(classConstantAccess);
    }

    public boolean visit(StaticMethodInvocation methodInvocation) {
        if (this.isChangeMethod()) {
            this.handlStaticDispatch((StaticDispatch)methodInvocation);
        }
        return super.visit(methodInvocation);
    }

    private void handlStaticDispatch(StaticDispatch dispatch) {
        ITypeBinding typeBinding;
        ASTNode member = dispatch.getMember();
        Identifier identifier = null;
        VariableBase variable = null;
        if (member instanceof Variable) {
            variable = (VariableBase)dispatch.getMember();
        }
        if (member instanceof FunctionInvocation) {
            variable = (VariableBase)member;
        }
        if (variable instanceof Variable) {
            identifier = this.getIdentifer((Variable)variable);
        }
        if (variable instanceof FunctionInvocation) {
            Expression functionName = ((FunctionInvocation)variable).getFunctionName().getName();
            if (functionName instanceof Variable) {
                identifier = this.getIdentifer((Variable)functionName);
            }
            if (functionName instanceof Identifier) {
                identifier = (Identifier)functionName;
            }
        }
        if (member instanceof Identifier) {
            identifier = (Identifier)member;
        }
        if (identifier != null && identifier.getName().equals(this.oldName) && (typeBinding = dispatch.getClassName().resolveTypeBinding()) != null && (typeBinding.equals((Object)this.type) || this.type != null && (this.type.isSubTypeCompatible(typeBinding) || typeBinding.isSubTypeCompatible(this.type)) || this.traitEqual(typeBinding, (ASTNode)identifier) || this.traitInSuperEqual(typeBinding, (ASTNode)identifier))) {
            this.addChange(identifier.getStart());
        }
    }

    public boolean visit(StaticFieldAccess fieldAccess) {
        if (this.isChangeField()) {
            this.handlStaticDispatch((StaticDispatch)fieldAccess);
        }
        return super.visit(fieldAccess);
    }

    public boolean visit(TraitAlias node) {
        if (this.type != null) {
            Expression expression = node.getTraitMethod();
            if (expression.getType() == 73) {
                this.checkIdentifier(((FullyQualifiedTraitMethodReference)expression).getFunctionName(), (node.getModifier() & 0x10) != 0);
            } else if (expression.getType() == 33) {
                this.checkIdentifier((Identifier)expression, (node.getModifier() & 0x10) != 0);
            }
            if (node.getFunctionName() != null) {
                this.checkIdentifier(node.getFunctionName(), (node.getModifier() & 0x10) != 0);
            }
        }
        return false;
    }

    private void checkIdentifier(Identifier identifier, boolean isPrivate) {
        ITypeBinding declClass;
        if (identifier.getName().equals(this.oldName) && (declClass = this.resolveDispatcherType(identifier)) != null) {
            if (declClass.equals((Object)this.type) || this.traitEqual(declClass, (ASTNode)identifier)) {
                this.addChange(identifier.getStart());
            } else if (this.type != null && (declClass.isSubTypeCompatible(this.type) || this.type.isSubTypeCompatible(declClass))) {
                if (!isPrivate) {
                    this.addChange(identifier.getStart());
                }
            } else if (this.traitInSuperEqual(declClass, (ASTNode)identifier)) {
                this.addChange(identifier.getStart());
            }
        }
    }

    private ITypeBinding resolveDispatcherType(Identifier identifier) {
        ITypeBinding typeBinding = null;
        ASTNode parent = identifier.getParent();
        if (parent.getType() == 73) {
            FullyQualifiedTraitMethodReference reference = (FullyQualifiedTraitMethodReference)parent;
            typeBinding = reference.getClassName().resolveTypeBinding();
            ITypeBinding temp = this.getTypeBinding(typeBinding, reference.getFunctionName().getName());
            if (temp != null) {
                return temp;
            }
        } else if (parent.getType() == 74) {
            TraitAlias traitAlias = (TraitAlias)parent;
            List nameList = ((TraitUseStatement)traitAlias.getParent().getParent()).getTraitList();
            String memberName = null;
            if (identifier == traitAlias.getFunctionName()) {
                Expression expression = traitAlias.getTraitMethod();
                if (expression.getType() == 73) {
                    FullyQualifiedTraitMethodReference fqtm = (FullyQualifiedTraitMethodReference)expression;
                    memberName = fqtm.getFunctionName().getName();
                } else {
                    memberName = ((Identifier)expression).getName();
                }
            } else {
                memberName = identifier.getName();
            }
            for (NamespaceName namespaceName : nameList) {
                typeBinding = namespaceName.resolveTypeBinding();
                ITypeBinding temp = this.getTypeBinding(typeBinding, memberName);
                if (temp == null) continue;
                return temp;
            }
            return null;
        }
        return typeBinding;
    }

    private ITypeBinding getTypeBinding(ITypeBinding typeBinding, String memberName) {
        if (typeBinding != null && typeBinding.isTrait() && typeBinding.getPHPElement() != null) {
            try {
                IModelElement[] members;
                IModelElement[] iModelElementArray = members = ((IType)typeBinding.getPHPElement()).getChildren();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement modelElement = iModelElementArray[n2];
                    if (modelElement.getElementName().equals(memberName) || modelElement.getElementName().equals("$" + memberName)) {
                        return typeBinding;
                    }
                    ++n2;
                }
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getRenameDescription() {
        return RENAME_CLASS_MEMBER;
    }

    public void close() {
        this.groups.clear();
    }
}

