/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPValue;
import org.eclipse.php.internal.debug.core.zend.model.WatchExpressionFactoryAdapter;

public class PHPVariable
extends PHPDebugElement
implements IVariable,
IPHPDataType {
    private Expression fExpression;
    private PHPValue fValue;
    private boolean fHasChanged = false;
    private String fName = null;

    public PHPVariable(PHPDebugTarget target, Expression expression) {
        super(target);
        this.fExpression = expression;
        this.fValue = new PHPValue(target, expression);
    }

    @Override
    public IPHPDataType.DataType getDataType() {
        return this.fExpression.getValue().getDataType();
    }

    public IValue getValue() throws DebugException {
        return this.fValue;
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            String endName = this.fExpression.getLastName();
            if (this.fExpression.hasFacet(IVariableFacet.Facet.KIND_OBJECT_MEMBER)) {
                int idx = endName.lastIndexOf(58);
                if (idx != -1) {
                    endName = endName.substring(idx + 1);
                }
            } else if (this.fExpression.hasFacet(IVariableFacet.Facet.KIND_ARRAY_MEMBER)) {
                endName = String.valueOf('[') + endName + ']';
            }
            this.fName = endName;
        }
        return this.fName;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fValue.getReferenceTypeName();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.fHasChanged;
    }

    public void setValue(String expression) throws DebugException {
        boolean status;
        PHPDebugTarget debugTarget = (PHPDebugTarget)this.getDebugTarget();
        DefaultExpressionsManager expressionManager = debugTarget.getExpressionManager();
        Expression changeVar = this.fExpression;
        if (this.fValue.getExpression().getValue().getDataType() == IPHPDataType.DataType.PHP_STRING) {
            expression = MessageFormat.format("\"{0}\"", expression);
        }
        if (!(status = expressionManager.assignValue(changeVar, expression, 1))) {
            Logger.debugMSG("[" + this + "] PHPValue: Problem changing variable value");
        }
        expressionManager.update(changeVar, 1);
        this.fValue.updateValue(changeVar.getValue());
        this.fireChangeEvent(512);
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return !this.fExpression.hasFacet(IVariableFacet.Facet.MOD_STATIC) && !this.fExpression.hasFacet(IVariableFacet.Facet.VIRTUAL_CLASS);
    }

    public boolean verifyValue(String value) throws DebugException {
        switch (this.fExpression.getValue().getDataType()) {
            case PHP_BOOL: {
                if (value.equalsIgnoreCase(String.valueOf(false)) || value.equalsIgnoreCase(String.valueOf(true))) break;
                return false;
            }
            case PHP_INT: 
            case PHP_FLOAT: {
                try {
                    Double.parseDouble(value);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWatchExpressionFactoryAdapter.class) {
            return new WatchExpressionFactoryAdapter();
        }
        if (adapter == Expression.class || adapter == IVariableFacet.class) {
            return this.fExpression;
        }
        return super.getAdapter(adapter);
    }

    protected Expression getExpression() {
        return this.fExpression;
    }

    protected String getFullName() {
        return this.fExpression.getFullName();
    }

    protected void update(Expression expression) {
        IPHPDataType.DataType previousDataType = this.getDataType();
        String previousValueString = null;
        if (this.fValue != null) {
            previousValueString = this.fExpression.getValue().getValueAsString();
        }
        this.fExpression = expression;
        this.fName = null;
        if (this.fValue != null && this.fValue.getDataType() == previousDataType) {
            this.fValue.update(expression);
        } else {
            this.fValue = new PHPValue((PHPDebugTarget)this.getDebugTarget(), this.fExpression);
        }
        if (previousValueString != null) {
            this.fHasChanged = !previousValueString.equals(this.fExpression.getValue().getValueAsString());
        }
    }
}

