/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.core.ast.nodes.Bindings;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.TypeBinding;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.dialogs.Messages;
import org.eclipse.php.internal.ui.dialogs.PHPSourceActionDialog;
import org.eclipse.php.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.php.ui.util.CodeGenerationUtils;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.editors.text.TextEditor;

public class OverrideMethodDialog
extends PHPSourceActionDialog {
    private Program fUnit = null;

    public OverrideMethodDialog(Shell shell, TextEditor editor, IType type, boolean isSubType) throws ModelException {
        super(shell, (ILabelProvider)new BindingLabelProvider(), new OverrideMethodContentProvider(), type, editor);
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.fUnit = CodeGenerationUtils.getASTRoot(type.getSourceModule(), document, type.getScriptProject().getProject());
        ITypeBinding binding = this.getTypeBinding(this.fUnit, type);
        ArrayList<IMethodBinding> toImplement = new ArrayList<IMethodBinding>();
        ArrayList<IMethodBinding> overridable = new ArrayList<IMethodBinding>();
        if (binding != null) {
            IMethodBinding[] methods = CodeGenerationUtils.getOverridableMethods(this.fUnit.getAST(), binding, false);
            IMethodBinding[] iMethodBindingArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding cur = iMethodBindingArray[n2];
                if (Bindings.isVisibleInHierarchy((IMethodBinding)cur)) {
                    overridable.add(cur);
                }
                ++n2;
            }
        }
        for (IMethodBinding element : overridable) {
            if (!Flags.isAbstract((int)element.getModifiers())) continue;
            toImplement.add(element);
        }
        Object[] toImplementArray = toImplement.toArray(new IMethodBinding[toImplement.size()]);
        this.setInitialSelections(toImplementArray);
        ArrayList<Object> expanded = new ArrayList<Object>(toImplementArray.length);
        int i = 0;
        while (i < toImplementArray.length) {
            if (!expanded.contains(toImplementArray[i].getDeclaringClass())) {
                expanded.add(toImplementArray[i].getDeclaringClass());
            }
            ++i;
        }
        ArrayList<ITypeBinding> types = new ArrayList<ITypeBinding>(overridable.size());
        for (IMethodBinding o : overridable) {
            if (types.contains(o.getDeclaringClass())) continue;
            types.add(o.getDeclaringClass());
        }
        Object[] typesArrays = types.toArray(new ITypeBinding[types.size()]);
        OverrideMethodComparator comparator = new OverrideMethodComparator(binding);
        if (expanded.isEmpty() && typesArrays.length > 0) {
            comparator.sort(null, typesArrays);
            expanded.add(typesArrays[0]);
        }
        this.setExpandedElements(expanded.toArray());
        ((OverrideMethodContentProvider)this.getContentProvider()).init(overridable.toArray(new IMethodBinding[0]), (ITypeBinding[])typesArrays);
        this.setTitle(Messages.OverrideMethodDialog_8);
        this.setMessage(null);
        this.setValidator(new OverrideMethodValidator(overridable.size()));
        this.setComparator(comparator);
        this.setContainerMode(true);
        this.setSize(60, 18);
        this.setInput(new Object());
    }

    private ITypeBinding getTypeBinding(Program fUnit, IType type) throws ModelException {
        PHPClassType evaluatedType = PHPClassType.fromIType((IType)type);
        return new TypeBinding(fUnit.getAST().getBindingResolver(), (IEvaluatedType)evaluatedType, (IModelElement)type);
    }

    @Override
    protected Control createLinkControl(Composite composite) {
        Link link = new Link(composite, 64);
        link.setText(Messages.OverrideMethodDialog_9);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverrideMethodDialog.this.openCodeTempatePage("org.eclipse.php.ui.editor.templates.php.codetemplates.overridecomment");
            }
        });
        link.setToolTipText(Messages.OverrideMethodDialog_11);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        link.setLayoutData((Object)gridData);
        return link;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        ViewForm pane = new ViewForm(composite, 0x800800);
        CheckboxTreeViewer treeViewer = super.createTreeViewer((Composite)pane);
        pane.setContent(treeViewer.getControl());
        GridLayout paneLayout = new GridLayout();
        paneLayout.marginHeight = 0;
        paneLayout.marginWidth = 0;
        paneLayout.numColumns = 1;
        pane.setLayout((Layout)paneLayout);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        pane.setLayoutData((Object)gd);
        treeViewer.getTree().setFocus();
        return treeViewer;
    }

    public boolean hasMethodsToOverride() {
        return this.getContentProvider().getElements(null).length > 0;
    }

    public Program getCompilationUnit() {
        return this.fUnit;
    }

    private static class OverrideMethodComparator
    extends ViewerComparator {
        private ITypeBinding[] fAllTypes = new ITypeBinding[0];

        public OverrideMethodComparator(ITypeBinding curr) {
            if (curr != null) {
                ITypeBinding[] superTypes = Bindings.getAllSuperTypes((ITypeBinding)curr);
                this.fAllTypes = new ITypeBinding[superTypes.length + 1];
                this.fAllTypes[0] = curr;
                System.arraycopy(superTypes, 0, this.fAllTypes, 1, superTypes.length);
            }
        }

        public int compare(Viewer viewer, Object first, Object second) {
            if (first instanceof ITypeBinding && second instanceof ITypeBinding) {
                ITypeBinding right = (ITypeBinding)second;
                ITypeBinding left = (ITypeBinding)first;
                if (right.isSubTypeCompatible(left)) {
                    return 1;
                }
                if (left.isSubTypeCompatible(right)) {
                    return -1;
                }
                return 0;
            }
            return super.compare(viewer, first, second);
        }
    }

    private static class OverrideMethodContentProvider
    implements ITreeContentProvider {
        private final Object[] fEmpty = new Object[0];
        private IMethodBinding[] fMethods;
        private IDialogSettings fSettings;
        private boolean fShowTypes;
        private Object[] fTypes;
        private static final String SETTINGS_SECTION = "OverrideMethodDialog";
        private static final String SETTINGS_SHOWTYPES = "showtypes";

        public OverrideMethodContentProvider() {
            IDialogSettings dialogSettings = PHPUiPlugin.getDefault().getDialogSettings();
            this.fSettings = dialogSettings.getSection(SETTINGS_SECTION);
            if (this.fSettings == null) {
                this.fSettings = dialogSettings.addNewSection(SETTINGS_SECTION);
                this.fSettings.put(SETTINGS_SHOWTYPES, true);
            }
            this.fShowTypes = this.fSettings.getBoolean(SETTINGS_SHOWTYPES);
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITypeBinding) {
                ArrayList<IMethodBinding> result = new ArrayList<IMethodBinding>(this.fMethods.length);
                IMethodBinding[] iMethodBindingArray = this.fMethods;
                int n = this.fMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethodBinding method = iMethodBindingArray[n2];
                    if (method.getDeclaringClass().equals((Object)((IBinding)parentElement))) {
                        result.add(method);
                    }
                    ++n2;
                }
                return result.toArray();
            }
            return this.fEmpty;
        }

        public Object[] getElements(Object inputElement) {
            return this.fShowTypes ? this.fTypes : this.fMethods;
        }

        public Object getParent(Object element) {
            if (element instanceof IMethodBinding) {
                return ((IMethodBinding)element).getDeclaringClass();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void init(IMethodBinding[] methods, ITypeBinding[] types) {
            this.fMethods = methods;
            this.fTypes = types;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class OverrideMethodValidator
    implements ISelectionStatusValidator {
        private static int fNumMethods;

        public OverrideMethodValidator(int entries) {
            fNumMethods = entries;
        }

        public IStatus validate(Object[] selection) {
            int count = 0;
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IMethodBinding) {
                    ++count;
                }
                ++n2;
            }
            if (count == 0) {
                return new Status(4, "org.eclipse.php.ui", "");
            }
            return new Status(1, "org.eclipse.php.ui", MessageFormat.format(Messages.OverrideMethodDialog_7, count, fNumMethods));
        }
    }
}

