/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.ui.folding.html.ProjectionAnnotationModelChanges;

class ProjectionViewerInformation {
    private ProjectionAnnotationModel fProjectionAnnotationModel;
    private IDocument fDocument;
    private IDocumentListener fDocumentListener;
    private boolean fIsDocumentChanging = false;
    private List<ProjectionAnnotationModelChanges> fQueuedAnnotationChanges;

    void applyChangesJOB() {
        IJobManager jobManager = Job.getJobManager();
        if (jobManager.find((Object)"Applying annotation model changes").length == 0) {
            ApplyAnnotationModelChangesJob job = new ApplyAnnotationModelChangesJob("Applying annotation model changes", this);
            job.setPriority(50);
            job.setSystem(true);
            job.schedule();
        }
    }

    public ProjectionViewerInformation(ProjectionViewer viewer) {
        this.fDocument = viewer.getDocument();
        this.fProjectionAnnotationModel = viewer.getProjectionAnnotationModel();
    }

    IDocument getDocument() {
        return this.fDocument;
    }

    private List<ProjectionAnnotationModelChanges> getQueuedAnnotationChanges() {
        if (this.fQueuedAnnotationChanges == null) {
            this.fQueuedAnnotationChanges = Collections.synchronizedList(new ArrayList());
        }
        return this.fQueuedAnnotationChanges;
    }

    void setIsDocumentChanging(boolean changing) {
        this.fIsDocumentChanging = changing;
    }

    private boolean isDocumentChanging() {
        return this.fIsDocumentChanging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void applyAnnotationModelChanges() {
        block20: {
            changesToApply = new ArrayList<ProjectionAnnotationModelChanges>();
            var3_3 = queuedChanges = this.getQueuedAnnotationChanges();
            synchronized (var3_3) {
                changesToApply.addAll(queuedChanges);
                queuedChanges.clear();
            }
            queuedChanges = null;
            if (changesToApply.size() <= 1) ** GOTO lbl72
            deletions = new HashSet<Annotation>();
            additions = new HashMap<Annotation, Position>();
            modifications = new HashSet<Annotation>();
            while (!changesToApply.isEmpty()) {
                changes = (ProjectionAnnotationModelChanges)changesToApply.remove(0);
                if (changes.getDeletions() != null) {
                    var10_15 = changes.getDeletions();
                    var9_13 = var10_15.length;
                    var8_10 = 0;
                    while (var8_10 < var9_13) {
                        el = var10_15[var8_10];
                        if (additions.containsKey(el)) {
                            additions.remove(el);
                        } else {
                            deletions.add(el);
                        }
                        if (modifications.contains(el)) {
                            modifications.remove(el);
                        }
                        ++var8_10;
                    }
                }
                if (changes.getAdditions() != null) {
                    for (Map.Entry<K, V> entry : changes.getAdditions().entrySet()) {
                        key = (Annotation)entry.getKey();
                        pos = (Position)entry.getValue();
                        if (deletions.contains(key)) {
                            deletions.remove(key);
                        }
                        additions.put(key, pos);
                    }
                }
                if (changes.getModifications() == null) continue;
                var10_15 = changes.getModifications();
                var9_13 = var10_15.length;
                var8_12 = 0;
                while (var8_12 < var9_13) {
                    el = var10_15[var8_12];
                    if (deletions.contains(el)) {
                        deletions.remove(el);
                    }
                    if (!additions.containsKey(el)) {
                        modifications.add(el);
                    }
                    ++var8_12;
                }
            }
            try {
                this.fProjectionAnnotationModel.modifyAnnotations(deletions.toArray(new Annotation[deletions.size()]), additions, modifications.toArray(new Annotation[modifications.size()]));
            }
            catch (Exception e) {
                Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
            }
            break block20;
lbl-1000:
            // 1 sources

            {
                changes = (ProjectionAnnotationModelChanges)changesToApply.remove(0);
                try {
                    this.fProjectionAnnotationModel.modifyAnnotations(changes.getDeletions(), changes.getAdditions(), changes.getModifications());
                    continue;
                }
                catch (Exception e) {
                    Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
                }
lbl72:
                // 3 sources

                ** while (!changesToApply.isEmpty())
            }
        }
    }

    boolean hasChangesQueued() {
        return !this.getQueuedAnnotationChanges().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAnnotationModelChanges(ProjectionAnnotationModelChanges newChange) {
        List<ProjectionAnnotationModelChanges> changes;
        List<ProjectionAnnotationModelChanges> list = changes = this.getQueuedAnnotationChanges();
        synchronized (list) {
            int index = changes.indexOf(newChange);
            if (index > -1) {
                changes.get(index).updateChange(newChange);
            } else {
                changes.add(newChange);
            }
        }
        if (!this.isDocumentChanging()) {
            this.applyAnnotationModelChanges();
        }
    }

    public void initialize() {
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new DocumentListener(this);
        }
        this.getDocument().addDocumentListener(this.fDocumentListener);
    }

    public void dispose() {
        if (this.fDocumentListener != null) {
            this.getDocument().removeDocumentListener(this.fDocumentListener);
        }
        if (this.fQueuedAnnotationChanges != null) {
            this.fQueuedAnnotationChanges.clear();
            this.fQueuedAnnotationChanges = null;
        }
    }

    private class ApplyAnnotationModelChangesJob
    extends Job {
        ProjectionViewerInformation fInfo;

        public ApplyAnnotationModelChangesJob(String name, ProjectionViewerInformation fInfo) {
            super(name);
            this.fInfo = fInfo;
        }

        public boolean belongsTo(Object family) {
            return this.getName().equals(family);
        }

        public IStatus run(IProgressMonitor monitor) {
            this.fInfo.applyAnnotationModelChanges();
            this.fInfo.setIsDocumentChanging(false);
            return Status.OK_STATUS;
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private ProjectionViewerInformation fInfo;

        public DocumentListener(ProjectionViewerInformation info) {
            this.fInfo = info;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            if (this.fInfo.getDocument() == document) {
                this.fInfo.setIsDocumentChanging(true);
            }
        }

        public void documentChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            if (document instanceof IDocumentExtension && this.fInfo.getDocument() == document && this.fInfo.hasChangesQueued()) {
                ((IDocumentExtension)document).registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)new PostDocumentChangedListener(this.fInfo));
            }
        }
    }

    private class PostDocumentChangedListener
    implements IDocumentExtension.IReplace {
        private ProjectionViewerInformation fInfo;

        public PostDocumentChangedListener(ProjectionViewerInformation info) {
            this.fInfo = info;
        }

        public void perform(IDocument document, IDocumentListener owner) {
            IJobManager jobManager = Job.getJobManager();
            if (jobManager.find((Object)"Applying annotation model changes").length == 0) {
                ApplyAnnotationModelChangesJob job = new ApplyAnnotationModelChangesJob("Applying annotation model changes", this.fInfo);
                job.setPriority(50);
                job.setSystem(true);
                job.schedule();
            }
        }
    }
}

