/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.phar.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.phar.wizard.IPharExportRunnable;
import org.eclipse.php.internal.ui.phar.wizard.IPharWizardPage;
import org.eclipse.php.internal.ui.phar.wizard.PharFileExportOperation;
import org.eclipse.php.internal.ui.phar.wizard.PharPackageWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class PharPackageWizard
extends Wizard
implements IExportWizard {
    private static String DIALOG_SETTINGS_KEY = "PharPackageWizard";
    private boolean fHasNewDialogSettings;
    PharPackage pharPackage;
    PharPackageWizardPage pharPackageWizardPage;
    private IStructuredSelection fSelection;

    public PharPackageWizard() {
        IDialogSettings workbenchSettings = PHPUiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fHasNewDialogSettings = true;
        } else {
            this.fHasNewDialogSettings = false;
            this.setDialogSettings(section);
        }
    }

    public boolean performFinish() {
        this.pharPackage.setElements(this.pharPackageWizardPage.getSelectedElementsWithoutContainedChildren());
        if (!this.executeExportOperation(new PharFileExportOperation(this.pharPackage, this.getShell()))) {
            return false;
        }
        if (this.fHasNewDialogSettings) {
            IDialogSettings workbenchSettings = PHPUiPlugin.getDefault().getDialogSettings();
            IDialogSettings section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < this.getPageCount()) {
            IWizardPage page = pages[i];
            if (page instanceof IPharWizardPage) {
                ((IPharWizardPage)page).finish();
            }
            ++i;
        }
        return true;
    }

    protected boolean executeExportOperation(IPharExportRunnable op) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"", null, (IStatus)status);
            return !status.matches(4);
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.pharPackageWizardPage = new PharPackageWizardPage(this.pharPackage, this.fSelection);
        this.addPage((IWizardPage)this.pharPackageWizardPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = this.getValidSelection();
        this.pharPackage = new PharPackage();
        this.setWindowTitle("");
        this.setNeedsProgressMonitor(true);
    }

    protected IStructuredSelection getValidSelection() {
        ISelection currentSelection = PHPUiPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            ArrayList selectedElements = new ArrayList(structuredSelection.size());
            for (Object selectedElement : structuredSelection) {
                if (selectedElement instanceof IProject) {
                    this.addProject(selectedElements, (IProject)selectedElement);
                    continue;
                }
                if (selectedElement instanceof IResource) {
                    this.addResource(selectedElements, (IResource)selectedElement);
                    continue;
                }
                if (selectedElement instanceof IScriptProject) {
                    this.addProject(selectedElements, ((IScriptProject)selectedElement).getProject());
                    continue;
                }
                if (!(selectedElement instanceof IModelElement)) continue;
                this.addJavaElement(selectedElements, (IModelElement)selectedElement);
            }
            return new StructuredSelection(selectedElements);
        }
        return StructuredSelection.EMPTY;
    }

    private void addJavaElement(List selectedElements, IModelElement selectedElement) {
        if (selectedElement != null && selectedElement.exists() && (selectedElement.getElementType() == 5 || selectedElement.getElementType() == 4)) {
            selectedElements.add(selectedElement);
        }
    }

    private void addResource(List selectedElements, IResource resource) {
        IModelElement je = DLTKCore.create((IResource)resource);
        if (je != null && je.exists() && je.getElementType() == 5) {
            selectedElements.add(je);
        } else {
            selectedElements.add(resource);
        }
    }

    private void addProject(List selectedElements, IProject project) {
        try {
            if (project.isAccessible() && project.hasNature("org.eclipse.php.core.PHPNature")) {
                selectedElements.add(DLTKCore.create((IProject)project));
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

