/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocContentState;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public abstract class AsciiDocBlock
extends Block {
    protected final Pattern startPattern;
    protected String startDelimiter = null;
    protected int blockLineCount = 0;
    private Matcher matcher;

    public AsciiDocBlock(Pattern startPattern) {
        this.startPattern = startPattern;
    }

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            this.startDelimiter = line;
            this.processBlockStart();
            ++this.blockLineCount;
        } else {
            if (this.isClosingLine(line, offset)) {
                this.setClosed(true);
                return -1;
            }
            ++this.blockLineCount;
            this.processBlockContent(line);
        }
        return -1;
    }

    protected void setStartDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
    }

    protected String getStartDelimiter() {
        return this.startDelimiter;
    }

    protected Pattern getStartPattern() {
        return this.startPattern;
    }

    protected boolean isClosingLine(String line, int offset) {
        return line.startsWith(this.startDelimiter.trim());
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.matcher = this.startPattern.matcher(line);
        return this.matcher.matches();
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.processBlockEnd();
        }
        super.setClosed(closed);
    }

    protected abstract void processBlockContent(String var1);

    protected abstract void processBlockStart();

    protected abstract void processBlockEnd();

    protected AsciiDocContentState getAsciiDocState() {
        return (AsciiDocContentState)this.state;
    }
}

