/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class SortElementsOperation
extends JavaModelOperation {
    public static final String CONTAINS_MALFORMED_NODES = "malformed";
    Comparator comparator;
    int[] positions;
    int apiLevel;

    public SortElementsOperation(int level, IJavaScriptElement[] elements, int[] positions, Comparator comparator) {
        super(elements);
        this.comparator = comparator;
        this.positions = positions;
        this.apiLevel = level;
    }

    protected int getMainAmountOfWork() {
        return this.elementsToProcess.length;
    }

    boolean checkMalformedNodes(ASTNode node) {
        Object property = node.getProperty(CONTAINS_MALFORMED_NODES);
        if (property == null) {
            return false;
        }
        return (Boolean)property;
    }

    protected boolean isMalformed(ASTNode node) {
        return (node.getFlags() & 1) != 0;
    }

    @Override
    protected void executeOperation() throws JavaScriptModelException {
        try {
            this.beginTask(Messages.operation_sortelements, this.getMainAmountOfWork());
            CompilationUnit copy = (CompilationUnit)this.elementsToProcess[0];
            IJavaScriptUnit unit = copy.getPrimary();
            IBuffer buffer = copy.getBuffer();
            if (buffer == null) {
                return;
            }
            char[] bufferContents = buffer.getCharacters();
            String result = this.processElement(unit, bufferContents);
            if (!CharOperation.equals(result.toCharArray(), bufferContents)) {
                copy.getBuffer().setContents(result);
            }
            this.worked(1);
        }
        finally {
            this.done();
        }
    }

    public TextEdit calculateEdit(JavaScriptUnit unit, TextEditGroup group) throws JavaScriptModelException {
        if (this.elementsToProcess.length != 1) {
            throw new JavaScriptModelException(new JavaModelStatus(968));
        }
        if (!(this.elementsToProcess[0] instanceof IJavaScriptUnit)) {
            throw new JavaScriptModelException(new JavaModelStatus(967, this.elementsToProcess[0]));
        }
        try {
            this.beginTask(Messages.operation_sortelements, this.getMainAmountOfWork());
            IJavaScriptUnit cu = (IJavaScriptUnit)this.elementsToProcess[0];
            String content = cu.getBuffer().getContents();
            ASTRewrite rewrite = this.sortCompilationUnit(unit, group);
            if (rewrite == null) {
                return null;
            }
            Document document = new Document(content);
            TextEdit textEdit = rewrite.rewriteAST((IDocument)document, null);
            return textEdit;
        }
        finally {
            this.done();
        }
    }

    private String processElement(IJavaScriptUnit unit, char[] source) {
        int max;
        int i;
        Document document = new Document(new String(source));
        CompilerOptions options = new CompilerOptions(unit.getJavaScriptProject().getOptions(true));
        ASTParser parser = ASTParser.newParser(this.apiLevel);
        parser.setCompilerOptions(options.getMap());
        parser.setSource(source);
        parser.setKind(8);
        parser.setResolveBindings(false);
        JavaScriptUnit ast = (JavaScriptUnit)parser.createAST(null);
        ASTRewrite rewriter = this.sortCompilationUnit(ast, null);
        if (rewriter == null) {
            return document.get();
        }
        TextEdit edits = rewriter.rewriteAST((IDocument)document, null);
        RangeMarker[] markers = null;
        if (this.positions != null) {
            markers = new RangeMarker[this.positions.length];
            i = 0;
            max = this.positions.length;
            while (i < max) {
                markers[i] = new RangeMarker(this.positions[i], 0);
                SortElementsOperation.insert(edits, (TextEdit)markers[i]);
                ++i;
            }
        }
        try {
            edits.apply((IDocument)document, 2);
            if (this.positions != null) {
                i = 0;
                max = markers.length;
                while (i < max) {
                    this.positions[i] = markers[i].getOffset();
                    ++i;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return document.get();
    }

    private ASTRewrite sortCompilationUnit(JavaScriptUnit ast, final TextEditGroup group) {
        ast.accept(new ASTVisitor(){

            @Override
            public boolean visit(JavaScriptUnit compilationUnit) {
                List types = compilationUnit.types();
                for (AbstractTypeDeclaration typeDeclaration : types) {
                    typeDeclaration.setProperty("relativeOrder", typeDeclaration.getStartPosition());
                    compilationUnit.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, SortElementsOperation.this.isMalformed(typeDeclaration));
                }
                return true;
            }

            @Override
            public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
                List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
                for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                    bodyDeclaration.setProperty("relativeOrder", bodyDeclaration.getStartPosition());
                    anonymousClassDeclaration.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, SortElementsOperation.this.isMalformed(bodyDeclaration));
                }
                return true;
            }

            @Override
            public boolean visit(TypeDeclaration typeDeclaration) {
                List bodyDeclarations = typeDeclaration.bodyDeclarations();
                for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                    bodyDeclaration.setProperty("relativeOrder", bodyDeclaration.getStartPosition());
                    typeDeclaration.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, SortElementsOperation.this.isMalformed(bodyDeclaration));
                }
                return true;
            }
        });
        final ASTRewrite rewriter = ASTRewrite.create(ast.getAST());
        final boolean[] hasChanges = new boolean[1];
        ast.accept(new ASTVisitor(){

            private void sortElements(List elements, ListRewrite listRewrite) {
                if (elements.size() == 0) {
                    return;
                }
                ArrayList myCopy = new ArrayList();
                myCopy.addAll(elements);
                Collections.sort(myCopy, SortElementsOperation.this.comparator);
                int i = 0;
                while (i < elements.size()) {
                    ASTNode newNode;
                    ASTNode oldNode = (ASTNode)elements.get(i);
                    if (oldNode != (newNode = (ASTNode)myCopy.get(i))) {
                        listRewrite.replace(oldNode, rewriter.createMoveTarget(newNode), group);
                        hasChanges[0] = true;
                    }
                    ++i;
                }
            }

            @Override
            public boolean visit(JavaScriptUnit compilationUnit) {
                if (SortElementsOperation.this.checkMalformedNodes(compilationUnit)) {
                    return true;
                }
                this.sortElements(compilationUnit.types(), rewriter.getListRewrite(compilationUnit, JavaScriptUnit.TYPES_PROPERTY));
                return true;
            }

            @Override
            public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
                if (SortElementsOperation.this.checkMalformedNodes(anonymousClassDeclaration)) {
                    return true;
                }
                this.sortElements(anonymousClassDeclaration.bodyDeclarations(), rewriter.getListRewrite(anonymousClassDeclaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY));
                return true;
            }

            @Override
            public boolean visit(TypeDeclaration typeDeclaration) {
                if (SortElementsOperation.this.checkMalformedNodes(typeDeclaration)) {
                    return true;
                }
                this.sortElements(typeDeclaration.bodyDeclarations(), rewriter.getListRewrite(typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY));
                return true;
            }
        });
        if (!hasChanges[0]) {
            return null;
        }
        return rewriter;
    }

    @Override
    public IJavaScriptModelStatus verify() {
        if (this.elementsToProcess.length != 1) {
            return new JavaModelStatus(968);
        }
        if (this.elementsToProcess[0] == null) {
            return new JavaModelStatus(968);
        }
        if (!(this.elementsToProcess[0] instanceof IJavaScriptUnit) || !((IJavaScriptUnit)this.elementsToProcess[0]).isWorkingCopy()) {
            return new JavaModelStatus(967, this.elementsToProcess[0]);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static void insert(TextEdit parent, TextEdit edit) {
        TextEdit child;
        if (!parent.hasChildren()) {
            parent.addChild(edit);
            return;
        }
        TextEdit[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            if (SortElementsOperation.covers(child, edit)) {
                SortElementsOperation.insert(child, edit);
                return;
            }
            ++i;
        }
        i = children.length - 1;
        while (i >= 0) {
            child = children[i];
            if (SortElementsOperation.covers(edit, child)) {
                parent.removeChild(i);
                edit.addChild(child);
            }
            --i;
        }
        parent.addChild(edit);
    }

    private static boolean covers(TextEdit thisEdit, TextEdit otherEdit) {
        if (thisEdit.getLength() == 0) {
            return false;
        }
        int thisOffset = thisEdit.getOffset();
        int thisEnd = thisEdit.getExclusiveEnd();
        if (otherEdit.getLength() == 0) {
            int otherOffset = otherEdit.getOffset();
            return thisOffset <= otherOffset && otherOffset < thisEnd;
        }
        int otherOffset = otherEdit.getOffset();
        int otherEnd = otherEdit.getExclusiveEnd();
        return thisOffset <= otherOffset && otherEnd <= thisEnd;
    }
}

