/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefContentAssistProvider;
import org.eclipse.egit.ui.internal.components.TitleAndImageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RefSpecDialog
extends TitleAndImageDialog {
    private final boolean pushMode;
    private final Repository repo;
    private final RemoteConfig config;
    private RefSpec spec = new RefSpec();
    private Text sourceText;
    private Text destinationText;
    private Button forceButton;
    private Text specString;
    private boolean autoSuggestDestination;

    public RefSpecDialog(Shell parentShell, Repository repository, RemoteConfig config, boolean push) {
        super(parentShell, push ? UIIcons.WIZBAN_PUSH : UIIcons.WIZBAN_FETCH);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repo = repository;
        this.config = config;
        this.pushMode = push;
        this.autoSuggestDestination = !this.pushMode;
        this.setHelpAvailable(false);
    }

    public RefSpecDialog(Shell parentShell, Repository repository, RemoteConfig config, RefSpec spec, boolean push) {
        this(parentShell, repository, config, push);
        this.spec = spec;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.RefSpecDialog_WindowTitle);
    }

    public void create() {
        super.create();
        if (this.pushMode) {
            this.setTitle(UIText.RefSpecDialog_PushTitle);
            this.setMessage(UIText.RefSpecDialog_PushMessage);
        } else {
            this.setTitle(UIText.RefSpecDialog_FetchTitle);
            this.setMessage(UIText.RefSpecDialog_FetchMessage);
        }
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout(2, false));
        URIish uriToCheck = this.pushMode ? (this.config.getPushURIs().isEmpty() ? (URIish)this.config.getURIs().get(0) : (URIish)this.config.getPushURIs().get(0)) : (URIish)this.config.getURIs().get(0);
        RefContentAssistProvider assistProvider = new RefContentAssistProvider(this.repo, uriToCheck, this.getShell());
        Label sourceLabel = new Label(main, 0);
        if (this.pushMode) {
            sourceLabel.setText(UIText.RefSpecDialog_SourceBranchPushLabel);
        } else {
            sourceLabel.setText(UIText.RefSpecDialog_SourceBranchFetchLabel);
        }
        this.sourceText = new Text(main, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.sourceText);
        if (this.spec != null && this.spec.getSource() != null) {
            this.sourceText.setText(this.spec.getSource());
        }
        this.sourceText.addModifyListener(event -> {
            if (this.sourceText.isFocusControl()) {
                try {
                    if (this.autoSuggestDestination) {
                        String name = this.sourceText.getText();
                        if (name.startsWith("refs/heads/")) {
                            name = name.substring("refs/heads/".length());
                        } else if (name.startsWith("refs/tags/")) {
                            name = name.substring("refs/tags/".length());
                        }
                        RefSpec sourceChanged = this.getSpec().setSource(this.sourceText.getText());
                        this.setSpec(sourceChanged.setDestination("refs/remotes/" + this.config.getName() + '/' + name));
                    } else {
                        this.setSpec(this.getSpec().setSource(this.sourceText.getText()));
                    }
                }
                catch (IllegalArgumentException | IllegalStateException runtimeException) {
                    // empty catch block
                }
            }
        });
        UIUtils.addRefContentProposalToText(this.sourceText, this.repo, () -> assistProvider.getRefsForContentAssist(true, this.pushMode));
        if (!this.pushMode) {
            final Button autoSuggest = new Button(main, 32);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)autoSuggest);
            autoSuggest.setText(UIText.RefSpecDialog_AutoSuggestCheckbox);
            autoSuggest.setSelection(true);
            autoSuggest.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RefSpecDialog.this.autoSuggestDestination = autoSuggest.getSelection();
                }
            });
        }
        Label destinationLabel = new Label(main, 0);
        if (this.pushMode) {
            destinationLabel.setText(UIText.RefSpecDialog_DestinationPushLabel);
        } else {
            destinationLabel.setText(UIText.RefSpecDialog_DestinationFetchLabel);
        }
        this.destinationText = new Text(main, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.destinationText);
        if (this.spec != null && this.spec.getDestination() != null) {
            this.destinationText.setText(this.spec.getDestination());
        }
        this.destinationText.addModifyListener(event -> {
            if (this.destinationText.isFocusControl()) {
                try {
                    this.setSpec(this.getSpec().setDestination(this.destinationText.getText()));
                }
                catch (IllegalArgumentException | IllegalStateException runtimeException) {
                    // empty catch block
                }
            }
        });
        UIUtils.addRefContentProposalToText(this.destinationText, this.repo, () -> assistProvider.getRefsForContentAssist(false, this.pushMode));
        this.forceButton = new Button(main, 32);
        this.forceButton.setText(UIText.RefSpecDialog_ForceUpdateCheckbox);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.forceButton);
        if (this.spec != null) {
            this.forceButton.setSelection(this.spec.isForceUpdate());
        }
        this.forceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RefSpecDialog.this.getSpec().isForceUpdate() == RefSpecDialog.this.forceButton.getSelection()) {
                    return;
                }
                RefSpecDialog.this.setSpec(RefSpecDialog.this.getSpec().setForceUpdate(RefSpecDialog.this.forceButton.getSelection()));
            }
        });
        Label stringLabel = new Label(main, 0);
        stringLabel.setText(UIText.RefSpecDialog_SpecificationLabel);
        this.specString = new Text(main, 2048);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.specString);
        if (this.spec != null) {
            this.specString.setText(this.spec.toString());
        }
        this.specString.addModifyListener(event -> {
            if (!this.specString.isFocusControl() || this.getSpec().toString().equals(this.specString.getText())) {
                return;
            }
            try {
                this.setSpec(new RefSpec(this.specString.getText()));
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
                // empty catch block
            }
        });
        RefSpecDialog.applyDialogFont((Control)main);
        return main;
    }

    public RefSpec getSpec() {
        return this.spec;
    }

    private void setSpec(RefSpec spec) {
        this.setErrorMessage(null);
        this.spec = spec;
        String newSourceText = spec.getSource() != null ? spec.getSource() : "";
        String newDestinationText = spec.getDestination() != null ? spec.getDestination() : "";
        String newStringText = spec.toString();
        if (!this.sourceText.getText().equals(newSourceText)) {
            this.sourceText.setText(newSourceText);
        }
        if (!this.destinationText.getText().equals(newDestinationText)) {
            this.destinationText.setText(newDestinationText);
        }
        if (!this.specString.getText().equals(newStringText)) {
            this.specString.setText(newStringText);
        }
        this.forceButton.setSelection(spec.isForceUpdate());
        if (this.sourceText.getText().length() == 0 || this.destinationText.getText().length() == 0) {
            this.setErrorMessage(UIText.RefSpecDialog_MissingDataMessage);
        }
        this.getButton(0).setEnabled(this.sourceText.getText().length() > 0 && this.destinationText.getText().length() > 0);
    }
}

