/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.List;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.compiler.ast.nodes.Comment;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class TaskTagHighlighting
extends AbstractSemanticHighlighting {
    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new TaskTagApply();
    }

    @Override
    protected void initDefaultPreferences() {
        this.getStyle().setDefaultTextColor(124, 165, 213).setBoldByDefault(true).setEnabledByDefault(true);
    }

    public String getDisplayName() {
        return Messages.TaskTagHighlighting_0;
    }

    protected class TaskTagApply
    extends AbstractSemanticApply {
        protected TaskTagApply() {
        }

        public boolean visit(Program program) {
            ISourceModule sourceModule = TaskTagHighlighting.this.getSourceModule();
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
            if (moduleDeclaration instanceof PHPModuleDeclaration) {
                for (Comment comment : ((PHPModuleDeclaration)moduleDeclaration).getCommentList()) {
                    List taskTags = comment.getTaskTags();
                    if (taskTags == null) continue;
                    for (Scalar taskTag : taskTags) {
                        TaskTagHighlighting.this.highlight(taskTag.start(), taskTag.end() - taskTag.start());
                    }
                }
            }
            return false;
        }
    }
}

