/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.sourcelookup.containers;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPFileSourceContainer;

public class PHPVariableSourceContainer
extends CompositeSourceContainer {
    private IPath fPath;
    private String[] validExtensions;

    public PHPVariableSourceContainer(IPath path) {
        this.fPath = path;
        this.updateExtentionList();
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        IPath path = DLTKCore.getResolvedVariablePath((IPath)this.fPath);
        File file = path.toFile();
        ISourceContainer[] container = new ISourceContainer[1];
        if (file.isDirectory()) {
            container[0] = new DirectorySourceContainer(file, false);
        } else {
            String fileName = file.getName();
            if (fileName.toLowerCase().endsWith(".zip")) {
                container[0] = new ExternalArchiveSourceContainer(file.getPath(), false);
            } else if (this.isPHPFile(fileName)) {
                container[0] = new PHPFileSourceContainer(file);
            }
        }
        return container;
    }

    public String getName() {
        return this.fPath.toString();
    }

    public ISourceContainerType getType() {
        return null;
    }

    private boolean isPHPFile(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String ext = fileName.substring(index + 1);
        int i = 0;
        while (i < this.validExtensions.length) {
            if (ext.equals(this.validExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateExtentionList() {
        IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        this.validExtensions = type.getFileSpecs(8);
    }
}

