/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.history.provider;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;

public abstract class FileRevision
implements IFileRevision {
    public static IFileRevision getFileRevisionFor(IFile file) {
        return new LocalFileRevision(file);
    }

    @Override
    public URI getURI() {
        return null;
    }

    @Override
    public long getTimestamp() {
        return -1L;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public String getContentIdentifier() {
        return null;
    }

    @Override
    public String getAuthor() {
        return null;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public ITag[] getBranches() {
        return new ITag[0];
    }

    @Override
    public ITag[] getTags() {
        return new ITag[0];
    }

    private static final class LocalFileRevision
    extends FileRevision {
        private final IFile file;

        private LocalFileRevision(IFile file) {
            this.file = file;
        }

        @Override
        public IStorage getStorage(IProgressMonitor monitor) {
            return this.file;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public long getTimestamp() {
            return this.file.getLocalTimeStamp();
        }

        @Override
        public URI getURI() {
            return this.file.getLocationURI();
        }

        @Override
        public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
            return this;
        }

        @Override
        public boolean isPropertyMissing() {
            return false;
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof LocalFileRevision) {
                LocalFileRevision other = (LocalFileRevision)obj;
                return other.file.equals((Object)this.file);
            }
            return false;
        }
    }
}

