/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.launcher;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.php.debug.ui.DebugServerConnectionTestRegistry;
import org.eclipse.php.debug.ui.IDebugServerConnectionTest;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.ServerEditWizardRunner;
import org.eclipse.php.profile.ui.launcher.AbstractPHPLaunchConfigurationProfilerTab;
import org.eclipse.php.profile.ui.launcher.Messages;

public class PHPWebPageLaunchConfigurationProfilerTab
extends AbstractPHPLaunchConfigurationProfilerTab {
    @Override
    protected void handleConfigureProfiler() {
        Server server = this.getServer();
        if (server == null || ServersManager.isNoneServer((Server)server)) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (ServerEditWizardRunner.runWizard((Server)server, (String)"org.eclipse.php.debug.ui.fragments.debuggerCompositeFragment") == 1) {
            monitor.setCanceled(true);
            return;
        }
        ServersManager.save();
    }

    @Override
    protected String getCurrentProfilerId() {
        Server server = this.getServer();
        if (server == null) {
            return "org.eclipse.php.debug.core.noneDebugger";
        }
        return server.getDebuggerId();
    }

    @Override
    protected String getNoProfilerMessage() {
        return MessageFormat.format(Messages.PHPWebPageLaunchConfigurationProfilerTab_No_profiler_is_attached, this.getServer().getName());
    }

    @Override
    protected void updateProfileTest() {
        this.profileTesters = DebugServerConnectionTestRegistry.getTests((String)this.getCurrentProfilerId());
        if (this.profileTesters.length == 0) {
            this.validateProfilerBtn.setEnabled(false);
        } else {
            this.validateProfilerBtn.setEnabled(true);
        }
    }

    @Override
    protected void performProfileTest() {
        IDebugServerConnectionTest[] iDebugServerConnectionTestArray = this.profileTesters;
        int n = this.profileTesters.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugServerConnectionTest debugServerTester = iDebugServerConnectionTestArray[n2];
            debugServerTester.testConnection(this.getServer(), this.getShell());
            ++n2;
        }
    }

    private Server getServer() {
        try {
            String serverName = this.getConfiguration().getAttribute("name", "");
            Server server = ServersManager.getServer((String)serverName);
            return server;
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

