/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.IOperationNode;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.ast.visitor.Visitor;

public class PrefixExpression
extends Expression
implements IOperationNode {
    public static final int OP_INC = 0;
    public static final int OP_DEC = 1;
    public static final int OP_UNPACK = 2;
    private Expression variable;
    private int operator;
    public static final ChildPropertyDescriptor VARIABLE_PROPERTY = new ChildPropertyDescriptor(PrefixExpression.class, "variable", Expression.class, true, true);
    public static final SimplePropertyDescriptor OPERATOR_PROPERTY = new SimplePropertyDescriptor(PrefixExpression.class, "operator", Integer.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(2);
        propertyList.add(VARIABLE_PROPERTY);
        propertyList.add(OPERATOR_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public PrefixExpression(AST ast) {
        super(ast);
    }

    public PrefixExpression(int start, int end, AST ast, Expression variable, int operator) {
        super(start, end, ast);
        if (variable == null) {
            throw new IllegalArgumentException();
        }
        this.setVariable(variable);
        this.setOperator(operator);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.variable.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.variable.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.variable.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<PrefixExpression");
        this.appendInterval(buffer);
        buffer.append(" operator='").append(PrefixExpression.getOperator(this.operator)).append("'>\n");
        this.variable.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</PrefixExpression>");
    }

    public static String getOperator(int operator) {
        switch (operator) {
            case 1: {
                return "--";
            }
            case 0: {
                return "++";
            }
            case 2: {
                return "...";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getType() {
        return 45;
    }

    public int getOperator() {
        return this.operator;
    }

    @Override
    public String getOperationString() {
        return PrefixExpression.getOperator(this.getOperator());
    }

    @Override
    public String getOperationString(int op) {
        return PrefixExpression.getOperator(op);
    }

    public void setOperator(int operator) {
        if (PrefixExpression.getOperator(operator) == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(OPERATOR_PROPERTY);
        this.operator = operator;
        this.postValueChange(OPERATOR_PROPERTY);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == OPERATOR_PROPERTY) {
            if (get) {
                return this.getOperator();
            }
            this.setOperator(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    public Expression getVariable() {
        return this.variable;
    }

    public void setVariable(Expression variable) {
        if (variable == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.variable;
        this.preReplaceChild(oldChild, variable, VARIABLE_PROPERTY);
        this.variable = variable;
        this.postReplaceChild(oldChild, variable, VARIABLE_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == VARIABLE_PROPERTY) {
            if (get) {
                return this.getVariable();
            }
            this.setVariable((VariableBase)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression variable = ASTNode.copySubtree(target, this.getVariable());
        PrefixExpression result = new PrefixExpression(this.getStart(), this.getEnd(), target, variable, this.getOperator());
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

