/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Assignment;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.visitor.Visitor;

public class StaticStatement
extends Statement {
    private ASTNode.NodeList<Expression> expressions = new ASTNode.NodeList(this, EXPRESSIONS_PROPERTY);
    public static final ChildListPropertyDescriptor EXPRESSIONS_PROPERTY = new ChildListPropertyDescriptor(StaticStatement.class, "expressions", Expression.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildListPropertyDescriptor> properyList = new ArrayList<ChildListPropertyDescriptor>(2);
        properyList.add(EXPRESSIONS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public StaticStatement(AST ast) {
        super(ast);
    }

    public StaticStatement(int start, int end, AST ast, List<Expression> expressions) {
        super(start, end, ast);
        if (expressions == null) {
            throw new IllegalArgumentException();
        }
        this.expressions.addAll(expressions);
    }

    public Variable[] getVariables() {
        LinkedList<Variable> vars = new LinkedList<Variable>();
        for (Expression node : this.expressions) {
            if (node instanceof Variable) {
                vars.add((Variable)node);
                continue;
            }
            assert (node instanceof Assignment);
            Assignment ass = (Assignment)node;
            vars.add((Variable)ass.getLeftHandSide());
        }
        return vars.toArray(new Variable[vars.size()]);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<StaticStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</StaticStatement>");
    }

    @Override
    public int getType() {
        return 54;
    }

    public List<Expression> expressions() {
        return this.expressions;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == EXPRESSIONS_PROPERTY) {
            return this.expressions();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List<Expression> expressions = ASTNode.copySubtrees(target, this.expressions());
        return new StaticStatement(this.getStart(), this.getEnd(), target, expressions);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

