/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.context;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.TraitDeclaration;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPNamespaceType;
import org.eclipse.php.internal.core.typeinference.PHPThisClassType;
import org.eclipse.php.internal.core.typeinference.context.FileContext;
import org.eclipse.php.internal.core.typeinference.context.INamespaceContext;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.typeinference.context.NamespaceContext;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPTraitType;

public abstract class ContextFinder
extends ASTVisitor {
    protected Stack<IContext> contextStack = new Stack();
    private ISourceModule sourceModule;
    IType declaringType;
    IType realType;

    public ContextFinder(ISourceModule sourceModule) {
        this.sourceModule = sourceModule;
    }

    public ContextFinder(ISourceModule sourceModule, IType realType, IType declaringType) {
        this.sourceModule = sourceModule;
        this.declaringType = declaringType;
        this.realType = realType;
    }

    public IContext getContext() {
        return null;
    }

    public boolean visit(ModuleDeclaration node) throws Exception {
        this.contextStack.push((IContext)new FileContext(this.sourceModule, node));
        boolean visitGeneral = this.visitGeneral((ASTNode)node);
        if (!visitGeneral) {
            this.contextStack.pop();
        }
        return visitGeneral;
    }

    public boolean visit(TypeDeclaration node) throws Exception {
        PHPClassType instanceType;
        if (node instanceof NamespaceDeclaration) {
            FileContext fileContext = (FileContext)this.contextStack.peek();
            PHPNamespaceType instanceType2 = ((NamespaceDeclaration)node).isGlobal() ? new PHPNamespaceType(null) : new PHPNamespaceType(node.getName());
            this.contextStack.push((IContext)new NamespaceContext((ISourceModuleContext)fileContext, instanceType2));
            boolean visitGeneral = this.visitGeneral((ASTNode)node);
            if (!visitGeneral) {
                this.contextStack.pop();
            }
            return visitGeneral;
        }
        ISourceModuleContext parentContext = (ISourceModuleContext)this.contextStack.peek();
        if (parentContext instanceof INamespaceContext && ((INamespaceContext)parentContext).getNamespace() != null) {
            instanceType = node instanceof TraitDeclaration ? new PHPTraitType(((INamespaceContext)parentContext).getNamespace(), node.getName()) : new PHPClassType(((INamespaceContext)parentContext).getNamespace(), node.getName());
        } else if (node instanceof TraitDeclaration) {
            if (this.declaringType != null && this.realType != null && this.declaringType.getElementName().equals(node.getName())) {
                if (this.realType.getParent() instanceof IType) {
                    IType ns = (IType)this.realType.getParent();
                    instanceType = new PHPThisClassType(ns.getElementName(), this.realType.getElementName(), this.realType);
                } else {
                    instanceType = new PHPThisClassType(this.realType.getElementName(), this.realType);
                }
            } else {
                instanceType = new PHPTraitType(node.getName());
            }
        } else {
            instanceType = new PHPClassType(node.getName());
        }
        this.contextStack.push((IContext)new TypeContext(parentContext, (IEvaluatedType)instanceType));
        boolean visitGeneral = this.visitGeneral((ASTNode)node);
        if (!visitGeneral) {
            this.contextStack.pop();
        }
        return visitGeneral;
    }

    public boolean visit(AnonymousClassDeclaration node) throws Exception {
        ISourceModuleContext parentContext = (ISourceModuleContext)this.contextStack.peek();
        MultiTypeType multiTypeType = new MultiTypeType();
        if (node.getSuperClass() != null) {
            multiTypeType.addType(PHPClassType.fromSimpleReference((SimpleReference)node.getSuperClass()));
        }
        if (node.getInterfaceList() != null) {
            for (TypeReference typeReference : node.getInterfaceList()) {
                multiTypeType.addType(PHPClassType.fromSimpleReference((SimpleReference)typeReference));
            }
        }
        this.contextStack.push((IContext)new TypeContext(parentContext, (IEvaluatedType)multiTypeType));
        return this.visitGeneral((ASTNode)node);
    }

    public boolean visit(MethodDeclaration node) throws Exception {
        LinkedList<String> argumentsList = new LinkedList<String>();
        LinkedList<IEvaluatedType> argTypes = new LinkedList<IEvaluatedType>();
        List args = node.getArguments();
        for (Argument a : args) {
            argumentsList.add(a.getName());
            argTypes.add(UnknownType.INSTANCE);
        }
        IContext parent = this.contextStack.peek();
        ModuleDeclaration rootNode = ((ISourceModuleContext)parent).getRootNode();
        this.contextStack.push(new MethodContext(parent, this.sourceModule, rootNode, node, argumentsList.toArray(new String[argumentsList.size()]), argTypes.toArray(new IEvaluatedType[argTypes.size()])));
        boolean visitGeneral = this.visitGeneral((ASTNode)node);
        if (!visitGeneral) {
            this.contextStack.pop();
        }
        return visitGeneral;
    }

    public boolean endvisit(ModuleDeclaration node) throws Exception {
        this.contextStack.pop();
        this.endvisitGeneral((ASTNode)node);
        return true;
    }

    public boolean endvisit(TypeDeclaration node) throws Exception {
        this.contextStack.pop();
        this.endvisitGeneral((ASTNode)node);
        return true;
    }

    public boolean endvisit(MethodDeclaration node) throws Exception {
        this.contextStack.pop();
        this.endvisitGeneral((ASTNode)node);
        return true;
    }

    public boolean endvisit(AnonymousClassDeclaration node) throws Exception {
        this.contextStack.pop();
        this.endvisitGeneral((ASTNode)node);
        return true;
    }

    public boolean visit(Expression s) throws Exception {
        if (s instanceof AnonymousClassDeclaration) {
            return this.visit((AnonymousClassDeclaration)s);
        }
        return super.visit(s);
    }

    public boolean endvisit(Expression s) throws Exception {
        if (s instanceof AnonymousClassDeclaration) {
            return this.endvisit((AnonymousClassDeclaration)s);
        }
        return super.endvisit(s);
    }
}

