/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.server.core.builtin.AbstractPHPServerRunner;
import org.eclipse.php.internal.server.core.builtin.Messages;
import org.eclipse.php.internal.server.core.builtin.PHPServerRunnerConfiguration;

public class DefaultPHPServerRunner
extends AbstractPHPServerRunner {
    private int fPort;

    @Override
    public void run(PHPServerRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        subMonitor.beginTask(Messages.DefaultPHPServerRunner_Launching_server____1, 2);
        subMonitor.subTask(Messages.DefaultPHPServerRunner_Constructing_command_line____2);
        this.fPort = configuration.getPort();
        String[] cmdLine = this.fetchCmdLineFromConf(configuration);
        subMonitor.worked(1);
        subMonitor.subTask(Messages.DefaultPHPServerRunner_Starting_server____3);
        if (monitor.isCanceled()) {
            return;
        }
        String workingDirectory = configuration.getWorkingDirectory();
        Process p = this.exec(cmdLine, new File(configuration.getWorkingDirectory()));
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        IProcess process = this.newProcess(launch, p, DefaultPHPServerRunner.renderProcessLabel(cmdLine, timestamp), this.getDefaultProcessMap());
        process.setAttribute("org.eclipse.debug.core.ATTR_PATH", cmdLine[0]);
        process.setAttribute(IProcess.ATTR_CMDLINE, this.renderCommandLine(cmdLine));
        String ltime = launch.getAttribute("org.eclipse.debug.core.launch.timestamp");
        process.setAttribute("org.eclipse.debug.core.launch.timestamp", ltime != null ? ltime : timestamp);
        if (workingDirectory != null) {
            process.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", workingDirectory);
        }
        subMonitor.worked(1);
        subMonitor.done();
    }

    protected String[] fetchCmdLineFromConf(PHPServerRunnerConfiguration configuration) {
        String phpIniFile = configuration.getIniFilePath();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(configuration.getExeFilePath());
        commands.add("-S");
        commands.add(String.valueOf(configuration.getHost()) + ':' + this.getServerPort());
        commands.add("-t");
        commands.add(configuration.getWorkingDirectory());
        if (StringUtils.isNotEmpty((CharSequence)phpIniFile)) {
            commands.add("-n");
            commands.add("-c");
            commands.add(phpIniFile);
        }
        return commands.toArray(new String[0]);
    }

    public static String renderProcessLabel(String[] commandLine, String timestamp) {
        String format = Messages.DefaultPHPServerRunner_0__0____1___2;
        return NLS.bind((String)format, (Object[])new String[]{commandLine[0], timestamp});
    }

    @Override
    public void stop() {
    }

    @Override
    public int getServerPort() {
        return this.fPort;
    }
}

