/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.fluent.Request;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.model.FavoriteList;
import org.eclipse.epp.internal.mpc.core.service.AbstractDataStorageService;
import org.eclipse.epp.internal.mpc.core.service.DefaultMarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.Messages;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.RequestTemplate;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.mpc.core.model.IFavoriteList;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.IUserFavoritesService;
import org.eclipse.epp.mpc.core.service.QueryHelper;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.userstorage.IBlob;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.util.ConflictException;
import org.eclipse.userstorage.util.NoServiceException;
import org.eclipse.userstorage.util.NotFoundException;
import org.eclipse.userstorage.util.ProtocolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserFavoritesService
extends AbstractDataStorageService
implements IUserFavoritesService {
    private static final String MARKETPLACE_USER_FAVORITES_ENDPOINT = "user/%s/favorites";
    private static final String RANDOM_FAVORITE_LISTS_ENDPOINT = "marketplace/favorites/random";
    private static final int MALFORMED_CONTENT_ERROR_CODE = 499;
    private static final String TEMPLATE_VARIABLE = "%s";
    private static final String JSON_LIST_OBJECTS_REGEX = "\\{([^\\{\\}]+)\\}";
    private static final Pattern JSON_LIST_OBJECTS_PATTERN = Pattern.compile("\\{([^\\{\\}]+)\\}", 8);
    private static final String JSON_ATTRIBUTE_OBJECT_LIST_REGEX = "\\{(?:.*,)?\\s*\"%s\"\\s*:\\s*\\[((?:\\s*\\{([^\\{\\}]+)\\}\\s*,?\\s*)*)\\],.*\\}";
    private static final String JSON_ATTRIBUTE_REGEX = "(?<=[,\\{]|^)\\s*\"(%s)\"\\s*:\\s*\"([^\"]*)\"\\s*(?=[,\\}]|$)";
    private static final Pattern JSON_MPC_FAVORITES_PATTERN = Pattern.compile(String.format("\\{(?:.*,)?\\s*\"%s\"\\s*:\\s*\\[((?:\\s*\\{([^\\{\\}]+)\\}\\s*,?\\s*)*)\\],.*\\}", "mpc_favorites"), 8);
    private static final Pattern JSON_FAVORITE_LISTS_PATTERN = Pattern.compile(String.format("\\{(?:.*,)?\\s*\"%s\"\\s*:\\s*\\[((?:\\s*\\{([^\\{\\}]+)\\}\\s*,?\\s*)*)\\],.*\\}", "users"), 8);
    private static final Pattern JSON_USER_ID_ATTRIBUTE_PATTERN = Pattern.compile(String.format("(?<=[,\\{]|^)\\s*\"(%s)\"\\s*:\\s*\"([^\"]*)\"\\s*(?=[,\\}]|$)", "name"), 8);
    private static final Pattern JSON_OWNER_ATTRIBUTE_PATTERN = Pattern.compile(String.format("(?<=[,\\{]|^)\\s*\"(%s)\"\\s*:\\s*\"([^\"]*)\"\\s*(?=[,\\}]|$)", "(?:full_)?name"), 8);
    private static final Pattern JSON_NAME_ATTRIBUTE_PATTERN = Pattern.compile(String.format("(?<=[,\\{]|^)\\s*\"(%s)\"\\s*:\\s*\"([^\"]*)\"\\s*(?=[,\\}]|$)", "mpc_list_name"), 8);
    private static final Pattern JSON_CONTENT_ID_ATTRIBUTE_PATTERN = Pattern.compile(String.format("(?<=[,\\{]|^)\\s*\"(%s)\"\\s*:\\s*\"([^\"]*)\"\\s*(?=[,\\}]|$)", "content_id"), 8);
    private static final Pattern JSON_LIST_URL_ATTRIBUTE_PATTERN = Pattern.compile(String.format("(?<=[,\\{]|^)\\s*\"(%s)\"\\s*:\\s*\"([^\"]*)\"\\s*(?=[,\\}]|$)", "html_mpc_favorites_url"), 8);
    private static final Pattern JSON_OWNER_ICON_ATTRIBUTE_PATTERN = Pattern.compile(String.format("(?<=[,\\{]|^)\\s*\"(%s)\"\\s*:\\s*\"([^\"]*)\"\\s*(?=[,\\}]|$)", "picture"), 8);
    private static final Pattern JSON_OWNER_PROFILE_URL_ATTRIBUTE_PATTERN = Pattern.compile(String.format("(?<=[,\\{]|^)\\s*\"(%s)\"\\s*:\\s*\"([^\"]*)\"\\s*(?=[,\\}]|$)", "html_profile_url"), 8);
    public static final Pattern FAVORITES_URL_PATTERN = Pattern.compile("(?:^|/)user/([^/#?]+)(/favorites)?([/#?].*)?$");
    private static final String KEY = "mpc_favorites";
    private static final int RETRY_COUNT = 3;
    private static final String SEPARATOR = ",";
    private final Map<String, Integer> favoritesCorrections = new HashMap<String, Integer>();
    private final Set<String> favorites = new HashSet<String>();

    protected IBlob getFavoritesBlob() {
        return this.getStorageService().getBlob(KEY);
    }

    @Override
    public Integer getFavoriteCount(INode node) {
        Integer favorited = node.getFavorited();
        if (favorited == null) {
            return null;
        }
        Integer correction = this.favoritesCorrections.get(node.getId());
        if (correction != null) {
            favorited = favorited + correction;
        }
        return favorited;
    }

    public Set<String> getLastFavoriteIds() {
        return Collections.unmodifiableSet(this.favorites);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getFavoriteIds(IProgressMonitor monitor) throws NoServiceException, AbstractDataStorageService.NotAuthorizedException, IllegalStateException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DefaultMarketplaceService_FavoritesRetrieve, (int)1000);
        try {
            String favoritesData = this.getFavoritesBlob().getContentsUTF();
            progress.worked(950);
            Set<String> result = this.parseFavoritesBlobData(favoritesData);
            UserFavoritesService userFavoritesService = this;
            synchronized (userFavoritesService) {
                this.favorites.clear();
                this.favorites.addAll(result);
            }
            return result;
        }
        catch (NotFoundException ex) {
            return new LinkedHashSet<String>();
        }
        catch (OperationCanceledException ex) {
            throw UserFavoritesService.processProtocolException(ex);
        }
        catch (ProtocolException ex) {
            throw UserFavoritesService.processProtocolException(ex);
        }
    }

    public List<INode> getLastFavorites() {
        Set<String> favoriteIds = this.getLastFavoriteIds();
        List<INode> favoriteNodes = UserFavoritesService.toNodes(favoriteIds);
        return favoriteNodes;
    }

    @Override
    public List<INode> getFavorites(IProgressMonitor monitor) throws NoServiceException, AbstractDataStorageService.NotAuthorizedException, IllegalStateException, IOException {
        Set<String> favoriteIds = this.getFavoriteIds(monitor);
        List<INode> favoriteNodes = UserFavoritesService.toNodes(favoriteIds);
        return favoriteNodes;
    }

    @Override
    public List<IFavoriteList> getRandomFavoriteLists(IProgressMonitor monitor) throws IOException {
        URI serviceUri = this.getStorageService().getServiceUri();
        URI randomFavoritesUri = serviceUri.resolve(RANDOM_FAVORITE_LISTS_ENDPOINT);
        return (List)new AbstractJSONListRequest<IFavoriteList>(randomFavoritesUri, JSON_FAVORITE_LISTS_PATTERN){

            @Override
            protected IFavoriteList parseListElement(String entryBody) {
                String favoritesListUrl;
                String label;
                String id = UserFavoritesService.findFavoritesListId(entryBody);
                if (id == null) {
                    return null;
                }
                String owner = UserFavoritesService.findFavoritesListOwner(entryBody);
                if (owner == null) {
                    owner = id;
                }
                if ((label = UserFavoritesService.findFavoritesListLabel(entryBody)) != null && (label.equals(id) || label.equals(owner))) {
                    label = null;
                }
                if ((favoritesListUrl = UserFavoritesService.this.getFavoritesListUrl(entryBody, id)) == null) {
                    return null;
                }
                String icon = UserFavoritesService.getAttribute(JSON_OWNER_ICON_ATTRIBUTE_PATTERN, null, entryBody);
                String profileUrl = UserFavoritesService.getAttribute(JSON_OWNER_PROFILE_URL_ATTRIBUTE_PATTERN, null, entryBody);
                IFavoriteList favoritesByUserId = QueryHelper.favoritesByUserId(id);
                ((FavoriteList)favoritesByUserId).setOwner(owner);
                ((FavoriteList)favoritesByUserId).setOwnerProfileUrl(profileUrl);
                ((FavoriteList)favoritesByUserId).setName(label);
                ((FavoriteList)favoritesByUserId).setUrl(favoritesListUrl);
                ((FavoriteList)favoritesByUserId).setIcon(icon);
                return favoritesByUserId;
            }
        }.execute(randomFavoritesUri);
    }

    private static String getAttribute(Pattern attributePattern, String attributeName, String entryBody) {
        Matcher matcher = attributePattern.matcher(entryBody);
        while (matcher.find()) {
            String matchedName = matcher.group(1);
            if (attributeName != null && !attributeName.equals(matchedName)) continue;
            return matcher.group(2);
        }
        return null;
    }

    private String getFavoritesListUrl(String entryBody, String id) {
        String marketplaceBaseUri = this.getMarketplaceBaseUri();
        String explicitUrl = UserFavoritesService.getAttribute(JSON_LIST_URL_ATTRIBUTE_PATTERN, null, entryBody);
        if (explicitUrl != null && explicitUrl.trim().length() > 0) {
            try {
                URL url = URLUtil.toURL(explicitUrl);
                URI uri = url.toURI();
                if (!uri.isAbsolute()) {
                    uri = new URI(marketplaceBaseUri).resolve(uri);
                }
                return uri.toURL().toString();
            }
            catch (Exception ex) {
                MarketplaceClientCore.error(NLS.bind((String)"Invalid list URL {0} for favorites list {1} - falling back to default URL", (Object)explicitUrl, (Object)id), ex);
            }
        }
        String path = String.format(MARKETPLACE_USER_FAVORITES_ENDPOINT, URLUtil.encode(id));
        return URLUtil.appendPath(marketplaceBaseUri, path);
    }

    private String getMarketplaceBaseUri() {
        String marketplaceBaseUri = this.getStorageService().getMarketplaceBaseUri();
        if (marketplaceBaseUri != null) {
            return marketplaceBaseUri;
        }
        IMarketplaceService defaultMarketplaceService = ServiceHelper.getMarketplaceServiceLocator().getDefaultMarketplaceService();
        if (defaultMarketplaceService != null) {
            return defaultMarketplaceService.getBaseUrl().toString();
        }
        return DefaultMarketplaceService.DEFAULT_SERVICE_LOCATION;
    }

    private static String findFavoritesListOwner(String entryBody) {
        return UserFavoritesService.findFavoritesNameOrId(entryBody, JSON_OWNER_ATTRIBUTE_PATTERN);
    }

    private static String findFavoritesListLabel(String entryBody) {
        return UserFavoritesService.findFavoritesNameOrId(entryBody, JSON_NAME_ATTRIBUTE_PATTERN);
    }

    private static String findFavoritesListId(String entryBody) {
        return UserFavoritesService.findFavoritesNameOrId(entryBody, JSON_USER_ID_ATTRIBUTE_PATTERN);
    }

    private static String findFavoritesNameOrId(String entryBody, Pattern pattern) {
        String result = null;
        Matcher matcher = pattern.matcher(entryBody);
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            if ("name".equals(name)) {
                if (result != null) continue;
                result = value;
                continue;
            }
            return value;
        }
        return result;
    }

    private static List<INode> toNodes(Collection<String> favoriteIds) {
        ArrayList<INode> favoriteNodes = new ArrayList<INode>(favoriteIds.size());
        for (String nodeId : favoriteIds) {
            INode node = QueryHelper.nodeById(nodeId);
            favoriteNodes.add(node);
        }
        return favoriteNodes;
    }

    protected Set<String> parseFavoritesBlobData(String favoritesData) {
        LinkedHashSet<String> favoriteIds = new LinkedHashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(favoritesData, SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String nodeId = tokenizer.nextToken();
            favoriteIds.add(nodeId);
        }
        return favoriteIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFavorites(Collection<? extends INode> nodes, IProgressMonitor monitor) throws NoServiceException, ConflictException, AbstractDataStorageService.NotAuthorizedException, IllegalStateException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UserFavoritesService_SettingUserFavorites, (int)1000);
        String favoritesData = this.createFavoritesBlobData(nodes);
        try {
            if (favoritesData == null || "".equals(favoritesData)) {
                this.getFavoritesBlob().delete();
            } else {
                this.getFavoritesBlob().setContentsUTF(favoritesData);
            }
            progress.worked(900);
        }
        catch (OperationCanceledException ex) {
            throw UserFavoritesService.processProtocolException(ex);
        }
        catch (ProtocolException ex) {
            throw UserFavoritesService.processProtocolException(ex);
        }
        UserFavoritesService userFavoritesService = this;
        synchronized (userFavoritesService) {
            String id;
            SubMonitor notifyNewProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(50), (int)nodes.size());
            HashSet<String> newFavorites = new HashSet<String>();
            for (INode iNode : nodes) {
                boolean newFavorite;
                id = iNode.getId();
                if (newFavorites.add(id) && (newFavorite = this.favorites.add(id))) {
                    this.didChangeFavorite(id, true);
                }
                notifyNewProgress.worked(1);
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progress.newChild(50), (int)this.favorites.size());
            Iterator<String> i = this.favorites.iterator();
            while (i.hasNext()) {
                id = i.next();
                if (!newFavorites.contains(id)) {
                    i.remove();
                    this.didChangeFavorite(id, false);
                }
                subMonitor.worked(1);
            }
        }
    }

    private void didChangeFavorite(String nodeId, boolean favorite) {
        Integer correction = this.favoritesCorrections.get(nodeId);
        if (correction == null) {
            correction = 0;
        }
        if ((correction = Integer.valueOf(correction + (favorite ? 1 : -1))) < -1) {
            correction = -1;
        } else if (correction > 1) {
            correction = 1;
        }
        if (correction == 0) {
            this.favoritesCorrections.remove(nodeId);
        } else {
            this.favoritesCorrections.put(nodeId, correction);
        }
    }

    protected String createFavoritesBlobData(Collection<? extends INode> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        ArrayList<String> nodeIds = new ArrayList<String>(nodes.size());
        for (INode iNode : nodes) {
            nodeIds.add(iNode.getId());
        }
        Collections.sort(nodeIds);
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (String nodeId : nodeIds) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(SEPARATOR);
            }
            stringBuilder.append(nodeId);
        }
        return stringBuilder.toString();
    }

    @Override
    public void setFavorite(INode node, boolean favorite, IProgressMonitor monitor) throws AbstractDataStorageService.NotAuthorizedException, ConflictException, IOException {
        this.alterFavorites(Collections.singleton(node), favorite, monitor);
    }

    @Override
    public void addFavorites(Collection<? extends INode> nodes, IProgressMonitor monitor) throws AbstractDataStorageService.NotAuthorizedException, ConflictException, IOException {
        this.alterFavorites(nodes, true, monitor);
    }

    @Override
    public void removeFavorites(Collection<? extends INode> nodes, IProgressMonitor monitor) throws AbstractDataStorageService.NotAuthorizedException, ConflictException, IOException {
        this.alterFavorites(nodes, false, monitor);
    }

    private void alterFavorites(Collection<? extends INode> nodes, boolean favorite, IProgressMonitor monitor) throws AbstractDataStorageService.NotAuthorizedException, ConflictException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UserFavoritesService_SettingUserFavorites, (int)1000);
        ConflictException conflictException = null;
        int i = 0;
        while (i < 3) {
            try {
                progress.setWorkRemaining(1000);
                this.doAlterFavorites(nodes, favorite, (IProgressMonitor)progress.newChild(800));
                progress.done();
                return;
            }
            catch (ConflictException e) {
                conflictException = e;
            }
            catch (OperationCanceledException ex) {
                throw UserFavoritesService.processProtocolException(ex);
            }
            catch (ProtocolException ex) {
                throw UserFavoritesService.processProtocolException(ex);
            }
            ++i;
        }
        if (conflictException != null) {
            throw conflictException;
        }
    }

    private void doAlterFavorites(Collection<? extends INode> nodes, boolean favorite, IProgressMonitor monitor) throws ConflictException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UserFavoritesService_SettingUserFavorites, (int)1000);
        List<INode> favorites = this.getFavorites((IProgressMonitor)progress.newChild(300));
        for (INode iNode : nodes) {
            INode currentFavorite = QueryHelper.findById(favorites, iNode);
            if (currentFavorite != null && !favorite) {
                favorites.remove(currentFavorite);
                continue;
            }
            if (currentFavorite != null || !favorite) continue;
            favorites.add(iNode);
        }
        this.setFavorites(favorites, (IProgressMonitor)progress.newChild(700));
    }

    @Override
    public List<INode> getFavorites(URI uri, IProgressMonitor monitor) throws IOException {
        List<String> nodeIds = this.getFavoriteIds(uri, monitor);
        return UserFavoritesService.toNodes(nodeIds);
    }

    private URI normalizeURI(URI uri) {
        UserFavoritesService.validateUri(uri);
        String marketplaceBaseUri = this.getMarketplaceBaseUri();
        marketplaceBaseUri = URLUtil.appendPath(marketplaceBaseUri, "");
        marketplaceBaseUri = URLUtil.setScheme(marketplaceBaseUri, uri.getScheme());
        if (!uri.toString().startsWith(marketplaceBaseUri)) {
            return uri;
        }
        Matcher matcher = FAVORITES_URL_PATTERN.matcher(uri.toString());
        if (matcher.find()) {
            String name = matcher.group(1);
            return this.getStorageService().getServiceUri().resolve("marketplace/favorites/?name=" + URLUtil.urlEncode(name));
        }
        return uri;
    }

    public static void validateUri(URI uri) {
        if ("".equals(uri.toString()) || (uri.getHost() == null || "".equals(uri.getHost())) && uri.getScheme() != null && uri.getScheme().toLowerCase().startsWith("http") || uri.getScheme() == null && (uri.getPath() == null || "".equals(uri.getPath()))) {
            throw new IllegalArgumentException(new URISyntaxException(uri.toString(), Messages.UserFavoritesService_uriMissingHost));
        }
    }

    @Override
    public List<String> getFavoriteIds(URI uri, IProgressMonitor monitor) throws IOException {
        URI normalizedUri = this.normalizeURI(uri);
        try {
            return (List)new AbstractJSONListRequest<String>(normalizedUri, JSON_MPC_FAVORITES_PATTERN){

                @Override
                protected String parseListElement(String listElement) {
                    Matcher contentIdMatcher = JSON_CONTENT_ID_ATTRIBUTE_PATTERN.matcher(listElement);
                    if (contentIdMatcher.find()) {
                        return contentIdMatcher.group(2);
                    }
                    return null;
                }
            }.execute(uri);
        }
        catch (FileNotFoundException e) {
            return new ArrayList<String>();
        }
    }

    private static ProtocolException malformedContentException(URI endpoint, String body) {
        return new ProtocolException("GET", endpoint, "1.1", 499, "Malformed response content: " + body);
    }

    public static boolean isInvalidFavoritesListException(Throwable error) {
        while (error != null) {
            CoreException coreException;
            IStatus status;
            if (UserFavoritesService.isMalformedContentException(error) || UserFavoritesService.isNotFoundException(error)) {
                return true;
            }
            if (error instanceof CoreException && (status = (coreException = (CoreException)error).getStatus()).isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus childStatus = iStatusArray[n2];
                    if (childStatus.getException() != null && UserFavoritesService.isInvalidFavoritesListException(childStatus.getException())) {
                        return true;
                    }
                    ++n2;
                }
            }
            error = error.getCause();
        }
        return false;
    }

    public static boolean isInvalidUrlException(Throwable error) {
        while (error != null) {
            CoreException coreException;
            IStatus status;
            if (error instanceof URISyntaxException || error instanceof MalformedURLException) {
                return true;
            }
            if (error instanceof CoreException && (status = (coreException = (CoreException)error).getStatus()).isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus childStatus = iStatusArray[n2];
                    if (childStatus.getException() != null && UserFavoritesService.isInvalidUrlException(childStatus.getException())) {
                        return true;
                    }
                    ++n2;
                }
            }
            error = error.getCause();
        }
        return false;
    }

    private static boolean isMalformedContentException(Throwable error) {
        if (error instanceof ProtocolException) {
            ProtocolException protocolException = (ProtocolException)error;
            switch (protocolException.getStatusCode()) {
                case 400: 
                case 405: 
                case 406: 
                case 417: 
                case 499: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean isNotFoundException(Throwable error) {
        if (error instanceof NotFoundException) {
            return true;
        }
        if (error instanceof ProtocolException) {
            ProtocolException protocolException = (ProtocolException)error;
            switch (protocolException.getStatusCode()) {
                case 404: 
                case 410: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractJSONListRequest<T>
    extends RequestTemplate<List<T>> {
        private final URI uri;
        private final Pattern listAttributePattern;

        private AbstractJSONListRequest(URI uri, Pattern listAttributePattern) {
            this.uri = uri;
            this.listAttributePattern = listAttributePattern;
        }

        @Override
        protected Request configureRequest(Request request, URI uri) {
            return super.configureRequest(request, uri).setHeader("User-Agent", "uss/1.0.0").addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        }

        @Override
        protected List<T> handleResponseStream(InputStream content, Charset charset) throws IOException {
            String body = AbstractJSONListRequest.read(content, charset);
            body = body.trim();
            return this.handleBody(this.uri, body);
        }

        private static String read(InputStream in, Charset charset) throws IOException {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtil.copy((InputStream)in, (OutputStream)baos);
                byte[] bytes = baos.toByteArray();
                if (bytes == null) {
                    return "";
                }
                String string = new String(bytes, charset == null ? "UTF-8" : charset.name());
                return string;
            }
            catch (RuntimeException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw ex;
            }
            finally {
                IOUtil.close((Closeable)in);
            }
        }

        protected List<T> handleBody(URI uri, String body) throws ProtocolException {
            ArrayList<T> favoriteIds = new ArrayList<T>();
            if (!"".equals(body)) {
                Matcher matcher = this.listAttributePattern.matcher(body);
                if (matcher.find()) {
                    String listBody = matcher.group(1);
                    Matcher entryMatcher = JSON_LIST_OBJECTS_PATTERN.matcher(listBody);
                    while (entryMatcher.find()) {
                        String listElement = entryMatcher.group(1);
                        T parsedElement = this.parseListElement(listElement);
                        if (parsedElement == null) continue;
                        favoriteIds.add(parsedElement);
                    }
                } else {
                    throw UserFavoritesService.malformedContentException(uri, body);
                }
            }
            return favoriteIds;
        }

        protected abstract T parseListElement(String var1);

        @Override
        protected Request createRequest(URI uri) {
            return Request.Get((URI)uri);
        }
    }
}

