/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.SearchRepository;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.GitHubException;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.Messages;
import org.eclipse.mylyn.internal.github.ui.RepositorySearchWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class RepositoryImportWizard
extends Wizard
implements IImportWizard {
    private final RepositorySearchWizardPage repositorySearchWizardPage = new RepositorySearchWizardPage();

    public RepositoryImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_IMPORT_WIZ"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.repositorySearchWizardPage);
    }

    private CloneOperation createCloneOperation(SearchRepository repo, RepositoryService service) throws IOException, URISyntaxException {
        Repository fullRepo = service.getRepository((IRepositoryIdProvider)repo);
        URIish uri = new URIish(fullRepo.getCloneUrl());
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String defaultRepoDir = RepositoryUtil.getDefaultRepositoryDir();
        File directory = new File(new File(defaultRepoDir, repo.getOwner()), repo.getName());
        int timeout = store.getInt("remote_connection_timeout");
        return new CloneOperation(uri, true, null, directory, "refs/heads/master", "origin", timeout);
    }

    public boolean performFinish() {
        final SearchRepository[] repositories = this.repositorySearchWizardPage.getRepositories();
        String name = repositories.length != 1 ? MessageFormat.format(Messages.RepositoryImportWizard_CloningRepositories, repositories.length) : Messages.RepositoryImportWizard_CloningRepository;
        Job job = new Job(name){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.RepositoryImportWizard_CloningRepository, repositories.length * 3);
                GitHubClient client = GitHub.configureClient((GitHubClient)new GitHubClient());
                RepositoryUtil repositoryUtil = org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil();
                RepositoryService service = new RepositoryService(client);
                SearchRepository[] searchRepositoryArray = repositories;
                int n = repositories.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchRepository repo = searchRepositoryArray[n2];
                    try {
                        String id = repo.getId();
                        monitor.setTaskName(MessageFormat.format(Messages.RepositoryImportWizard_CreatingOperation, id));
                        CloneOperation op = RepositoryImportWizard.this.createCloneOperation(repo, service);
                        monitor.worked(1);
                        monitor.setTaskName(MessageFormat.format(Messages.RepositoryImportWizard_Cloning, id));
                        SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
                        op.run((IProgressMonitor)sub);
                        sub.done();
                        monitor.setTaskName(MessageFormat.format(Messages.RepositoryImportWizard_Registering, id));
                        repositoryUtil.addConfiguredRepository(op.getGitDir());
                        monitor.worked(1);
                    }
                    catch (InvocationTargetException e) {
                        GitHubUi.logError(e);
                    }
                    catch (InterruptedException e) {
                        GitHubUi.logError(e);
                    }
                    catch (IOException e) {
                        GitHubUi.logError(GitHubException.wrap((IOException)e));
                    }
                    catch (URISyntaxException e) {
                        GitHubUi.logError(e);
                    }
                    ++n2;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        IWorkbenchSiteProgressService progress = (IWorkbenchSiteProgressService)PlatformUI.getWorkbench().getService(IWorkbenchSiteProgressService.class);
        if (progress != null) {
            progress.schedule(job);
        } else {
            job.schedule();
        }
        return true;
    }
}

