/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.core.ValidatorRuntime;

public abstract class AbstractValidatorType
implements IValidatorType {
    protected final Map<String, IValidator> validators = new HashMap<String, IValidator>();

    @Override
    public IValidator[] getValidators() {
        return this.validators.values().toArray(new IValidator[this.validators.size()]);
    }

    @Override
    public IValidator findValidator(String id) {
        return this.validators.get(id);
    }

    @Override
    public void addValidator(IValidator validator) {
        Assert.isLegal((!this.isBuiltin() ? 1 : 0) != 0, (String)"could not add to the built-in validator type");
        if (validator.getValidatorType() != this) {
            throw new IllegalArgumentException("Wrong validator type");
        }
        this.validators.put(validator.getID(), validator);
    }

    @Override
    public void disposeValidator(String id) {
        Assert.isTrue((!this.isBuiltin() ? 1 : 0) != 0);
        IValidator validator = this.validators.remove(id);
        if (validator != null) {
            ValidatorRuntime.fireValidatorRemoved(validator);
        }
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public IValidator[] getAllValidators(IProject project) {
        return this.getValidators();
    }
}

