/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.commons.ui.TaskListImageDescriptor;
import org.eclipse.mylyn.internal.tasks.core.ITaskRepositoryFilter;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.AddRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewCategoryAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewQueryAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesSorter;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class NewTaskAction
extends BaseSelectionListenerAction
implements IMenuCreator,
IViewActionDelegate,
IExecutableExtension {
    private static final String LABEL_NEW_TASK = Messages.NewTaskAction_new_task;
    public static final String ID = "org.eclipse.mylyn.tasklist.ui.repositories.actions.create";
    private boolean skipRepositoryPage = false;
    private boolean localTask = false;
    private Menu dropDownMenu;

    public NewTaskAction(String label, boolean alwaysShowWizard) {
        super(label);
        if (!alwaysShowWizard) {
            this.setMenuCreator(this);
        }
        this.setText(label);
        this.setToolTipText(label);
        this.setId(ID);
        this.setEnabled(true);
        this.setImageDescriptor(TasksUiImages.TASK_NEW);
    }

    public NewTaskAction() {
        this(LABEL_NEW_TASK, false);
    }

    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null && !shell.isDisposed()) {
            if (this.localTask) {
                TasksUiUtil.openNewLocalTaskEditor(shell, null);
            } else if (this.skipRepositoryPage) {
                TasksUiUtil.openNewTaskEditor(shell, null, TasksUiUtil.getSelectedRepository());
            } else {
                TasksUiUtil.openNewTaskEditor(shell, null, null);
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if ("skipFirstPage".equals(data)) {
            this.skipRepositoryPage = true;
        }
        if ("local".equals(data)) {
            this.localTask = true;
        }
    }

    public void dispose() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    private void addActionsToMenu() {
        NewTaskAction newTaskAction = new NewTaskAction(LABEL_NEW_TASK, true);
        newTaskAction.setText(Messages.NewTaskAction_Show_Wizard_Label);
        new ActionContributionItem((IAction)newTaskAction).fill(this.dropDownMenu, -1);
        new Separator().fill(this.dropDownMenu, -1);
        HashSet<TaskRepository> includedRepositories = new HashSet<TaskRepository>();
        TaskRepository localRepository = TasksUi.getRepositoryManager().getRepository("local", "local");
        this.addRepositoryAction(localRepository);
        IWorkingSet workingSet = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getAggregateWorkingSet();
        if (workingSet != null && !workingSet.isEmpty()) {
            IAdaptable[] iAdaptableArray = workingSet.getElements();
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable iterable_element = iAdaptableArray[n2];
                if (iterable_element instanceof RepositoryQuery) {
                    String repositoryUrl = ((RepositoryQuery)iterable_element).getRepositoryUrl();
                    String connectorKind = ((RepositoryQuery)iterable_element).getConnectorKind();
                    TaskRepository repository = TasksUi.getRepositoryManager().getRepository(connectorKind, repositoryUrl);
                    this.markForInclusion(includedRepositories, repository);
                }
                ++n2;
            }
        }
        if (includedRepositories.isEmpty()) {
            for (TaskRepository repository : TasksUi.getRepositoryManager().getAllRepositories()) {
                this.markForInclusion(includedRepositories, repository);
            }
        }
        if (!includedRepositories.isEmpty()) {
            ArrayList listOfRepositories = new ArrayList(includedRepositories);
            final TaskRepositoriesSorter comparator = new TaskRepositoriesSorter();
            Collections.sort(listOfRepositories, new Comparator<TaskRepository>(){

                @Override
                public int compare(TaskRepository arg0, TaskRepository arg1) {
                    return comparator.compare(null, arg0, arg1);
                }
            });
            for (TaskRepository taskRepository : listOfRepositories) {
                this.addRepositoryAction(taskRepository);
            }
        }
        new Separator().fill(this.dropDownMenu, -1);
        new ActionContributionItem((IAction)new NewQueryAction()).fill(this.dropDownMenu, -1);
        new ActionContributionItem((IAction)new NewCategoryAction()).fill(this.dropDownMenu, -1);
        new Separator().fill(this.dropDownMenu, -1);
        AddRepositoryAction action = new AddRepositoryAction();
        action.setText(Messages.NewTaskAction_Add_Repository);
        action.setImageDescriptor(null);
        new ActionContributionItem((IAction)action).fill(this.dropDownMenu, -1);
        new Separator("additions");
    }

    private void markForInclusion(Set<TaskRepository> includedRepositories, TaskRepository repository) {
        AbstractRepositoryConnector connector;
        if (repository != null && !repository.getConnectorKind().equals("local") && (connector = TasksUi.getRepositoryConnector(repository.getConnectorKind())) != null && ITaskRepositoryFilter.CAN_CREATE_NEW_TASK.accept(repository, connector)) {
            includedRepositories.add(repository);
        }
    }

    private RepositorySelectionAction addRepositoryAction(TaskRepository repository) {
        if (repository == null) {
            return null;
        }
        RepositorySelectionAction action = new RepositorySelectionAction(repository);
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        action.setText(repository.getRepositoryLabel());
        ImageDescriptor overlay = TasksUiPlugin.getDefault().getBrandManager().getOverlayIcon(repository);
        TaskListImageDescriptor compositeDescriptor = new TaskListImageDescriptor(TasksUiImages.TASK_NEW, overlay, false, false);
        action.setImageDescriptor((ImageDescriptor)compositeDescriptor);
        item.fill(this.dropDownMenu, -1);
        return action;
    }

    private class RepositorySelectionAction
    extends Action {
        private final TaskRepository repository;

        public RepositorySelectionAction(TaskRepository repository) {
            this.repository = repository;
            this.setText(repository.getRepositoryLabel());
        }

        public void run() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (this.repository.getConnectorKind().equalsIgnoreCase("local")) {
                TasksUiUtil.openNewLocalTaskEditor(shell, null);
            } else {
                TasksUiUtil.openNewTaskEditor(shell, null, this.repository);
            }
        }
    }
}

