/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlinkDetector;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementImplementationHyperlink;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;

public class JavaElementHyperlinkImplementationDetector
extends JavaElementHyperlinkDetector {
    @Override
    protected void addHyperlinks(List<IHyperlink> hyperlinksCollector, IRegion wordRegion, SelectionDispatchAction openAction, IJavaElement element, boolean qualify, JavaEditor editor) {
        if (JavaElementHyperlinkImplementationDetector.canOpenImplementation(element) && SelectionConverter.canOperateOn(editor)) {
            hyperlinksCollector.add(new JavaElementImplementationHyperlink(wordRegion, openAction, element, qualify, (IEditorPart)editor));
        }
    }

    public static boolean canOpenImplementation(IJavaElement element) {
        return element.getElementType() == 9 || JavaElementHyperlinkImplementationDetector.isImplementableType(element);
    }

    private static boolean isImplementableType(IJavaElement element) {
        if (element.getElementType() == 7) {
            IType type = (IType)element;
            try {
                if (type.isClass() || type.isInterface() && !type.isAnnotation()) {
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }
}

