/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.AnnotationElementImplementor;
import org.eclipse.scout.sdk.core.model.api.internal.SourceRange;
import org.eclipse.scout.sdk.core.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;
import org.eclipse.scout.sdk.core.model.spi.internal.metavalue.MetaValueFactory;

public class BindingAnnotationElementWithJdt
extends AbstractJavaElementWithJdt<IAnnotationElement>
implements AnnotationElementSpi {
    private final BindingAnnotationWithJdt m_declaringAnnotation;
    private final ElementValuePair m_binding;
    private final String m_name;
    private final boolean m_syntheticDefaultValue;
    private Expression m_sourceExpression;
    private IMetaValue m_value;
    private ISourceRange m_source;
    private ISourceRange m_expressionSource;

    BindingAnnotationElementWithJdt(JavaEnvironmentWithJdt env, BindingAnnotationWithJdt owner, ElementValuePair bindingPair, boolean syntheticDefaultValue) {
        super(env);
        this.m_declaringAnnotation = (BindingAnnotationWithJdt)Validate.notNull((Object)owner);
        this.m_binding = (ElementValuePair)Validate.notNull((Object)bindingPair);
        this.m_syntheticDefaultValue = syntheticDefaultValue;
        this.m_name = new String(this.m_binding.getName());
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        return null;
    }

    @Override
    protected IAnnotationElement internalCreateApi() {
        return new AnnotationElementImplementor(this);
    }

    public ElementValuePair getInternalBinding() {
        return this.m_binding;
    }

    @Override
    public String getElementName() {
        return this.m_name;
    }

    @Override
    public IMetaValue getMetaValue() {
        if (this.m_value == null) {
            Object value = this.m_binding.getValue();
            this.m_value = SpiWithJdtUtils.resolveCompiledValue(this.m_env, this.m_declaringAnnotation.getOwner(), value);
            if (this.m_value == null) {
                this.m_value = MetaValueFactory.createUnknown(value);
            }
        }
        return this.m_value;
    }

    @Override
    public boolean isDefaultValue() {
        return this.m_syntheticDefaultValue;
    }

    @Override
    public BindingAnnotationWithJdt getDeclaringAnnotation() {
        return this.m_declaringAnnotation;
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            MemberValuePair pairDecl = SpiWithJdtUtils.findAnnotationValueDeclaration(this);
            this.m_source = pairDecl == null ? ISourceRange.NO_SOURCE : new SourceRange(pairDecl.toString(), pairDecl.sourceStart, pairDecl.sourceEnd);
        }
        return this.m_source;
    }

    protected Expression getSourceExpression() {
        MemberValuePair pairDecl;
        if (this.m_sourceExpression == null && (pairDecl = SpiWithJdtUtils.findAnnotationValueDeclaration(this)) != null) {
            this.m_sourceExpression = pairDecl.value;
        }
        return this.m_sourceExpression;
    }

    @Override
    public ISourceRange getSourceOfExpression() {
        if (this.m_expressionSource == null) {
            Expression expr = this.getSourceExpression();
            this.m_expressionSource = expr == null ? ISourceRange.NO_SOURCE : new SourceRange(expr.toString(), expr.sourceStart, expr.sourceEnd);
        }
        return this.m_expressionSource;
    }
}

