/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;

public class ClasspathEntry {
    private final FileSystem.Classpath m_classpath;
    private final String m_encoding;

    public ClasspathEntry(FileSystem.Classpath classpath, String encoding) {
        this.m_classpath = classpath;
        this.m_encoding = encoding;
    }

    public FileSystem.Classpath getClasspath() {
        return this.m_classpath;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public static Set<FileSystem.Classpath> toClassPaths(Set<ClasspathEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<FileSystem.Classpath> result = new LinkedHashSet<FileSystem.Classpath>(entries.size());
        for (ClasspathEntry entry : entries) {
            result.add(entry.getClasspath());
        }
        return result;
    }

    public String toString() {
        return this.m_classpath == null ? "null" : this.m_classpath.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_classpath == null ? 0 : this.m_classpath.hashCode());
        result = 31 * result + (this.m_encoding == null ? 0 : this.m_encoding.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClasspathEntry other = (ClasspathEntry)obj;
        if (this.m_classpath == null ? other.m_classpath != null : !this.m_classpath.equals(other.m_classpath)) {
            return false;
        }
        return !(this.m_encoding == null ? other.m_encoding != null : !this.m_encoding.equals(other.m_encoding));
    }
}

