/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.AnnotationElementImplementor;
import org.eclipse.scout.sdk.core.model.api.internal.SourceRange;
import org.eclipse.scout.sdk.core.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;
import org.eclipse.scout.sdk.core.model.spi.internal.metavalue.MetaValueFactory;

public class DeclarationAnnotationElementWithJdt
extends AbstractJavaElementWithJdt<IAnnotationElement>
implements AnnotationElementSpi {
    private final DeclarationAnnotationWithJdt m_declaringAnnotation;
    private final MemberValuePair m_astNode;
    private final String m_name;
    private final boolean m_syntheticDefaultValue;
    private IMetaValue m_value;
    private ISourceRange m_source;
    private ISourceRange m_expressionSource;

    DeclarationAnnotationElementWithJdt(JavaEnvironmentWithJdt env, DeclarationAnnotationWithJdt declaringAnnotation, MemberValuePair astNode, boolean syntheticDefaultValue) {
        super(env);
        this.m_declaringAnnotation = declaringAnnotation;
        this.m_astNode = astNode;
        this.m_syntheticDefaultValue = syntheticDefaultValue;
        this.m_name = new String(astNode.name);
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        return null;
    }

    @Override
    protected IAnnotationElement internalCreateApi() {
        return new AnnotationElementImplementor(this);
    }

    @Override
    public String getElementName() {
        return this.m_name;
    }

    @Override
    public IMetaValue getMetaValue() {
        if (this.m_value == null) {
            ClassScope scope = SpiWithJdtUtils.classScopeOf(this.m_declaringAnnotation.getOwner());
            Object compiledValue = SpiWithJdtUtils.compileExpression(this.m_astNode.value, scope);
            this.m_value = SpiWithJdtUtils.resolveCompiledValue(this.m_env, this.m_declaringAnnotation.getOwner(), compiledValue);
            if (this.m_value == null) {
                this.m_value = MetaValueFactory.createUnknown(compiledValue);
            }
        }
        return this.m_value;
    }

    @Override
    public DeclarationAnnotationWithJdt getDeclaringAnnotation() {
        return this.m_declaringAnnotation;
    }

    @Override
    public boolean isDefaultValue() {
        return this.m_syntheticDefaultValue;
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            this.m_source = new SourceRange(this.m_astNode.toString(), this.m_astNode.sourceStart, this.m_astNode.sourceEnd);
        }
        return this.m_source;
    }

    @Override
    public ISourceRange getSourceOfExpression() {
        if (this.m_expressionSource == null) {
            Expression expr = this.m_astNode.value;
            this.m_expressionSource = expr == null ? ISourceRange.NO_SOURCE : new SourceRange(expr.toString(), expr.sourceStart, expr.sourceEnd);
        }
        return this.m_expressionSource;
    }
}

