/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.CompilationUnitImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationImportWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class DeclarationCompilationUnitWithJdt
extends AbstractJavaElementWithJdt<ICompilationUnit>
implements CompilationUnitSpi {
    private final CompilationUnitDeclaration m_astNode;
    private PackageSpi m_package;
    private String m_fileName;
    private TypeSpi m_mainType;
    private List<DeclarationTypeWithJdt> m_types;
    private List<DeclarationImportWithJdt> m_imports;
    private ISourceRange m_source;
    private ISourceRange m_javaDocSource;

    DeclarationCompilationUnitWithJdt(JavaEnvironmentWithJdt env, CompilationUnitDeclaration astNode) {
        super(env);
        this.m_astNode = (CompilationUnitDeclaration)Validate.notNull((Object)astNode);
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        for (DeclarationTypeWithJdt oldType : this.getTypes()) {
            TypeSpi newType = (TypeSpi)oldType.internalFindNewElement(newEnv);
            if (newType == null) continue;
            return newType.getCompilationUnit();
        }
        return null;
    }

    @Override
    protected ICompilationUnit internalCreateApi() {
        return new CompilationUnitImplementor(this);
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    public CompilationUnitDeclaration getInternalCompilationUnitDeclaration() {
        return this.m_astNode;
    }

    @Override
    public PackageSpi getPackage() {
        if (this.m_package == null) {
            char[][] importName;
            ImportReference currentPackage = this.m_astNode.currentPackage;
            if (currentPackage != null && (importName = currentPackage.getImportName()) != null && importName.length > 0) {
                this.m_package = this.m_env.createPackage(CharOperation.toString((char[][])importName));
            }
            if (this.m_package == null) {
                this.m_package = this.m_env.createDefaultPackage();
            }
        }
        return this.m_package;
    }

    @Override
    public TypeSpi findTypeBySimpleName(String simpleName) {
        TypeSpi result = this.findTypeBySimpleNameInternal(simpleName, (Scope)this.m_astNode.scope, this.m_env);
        if (result != null) {
            return result;
        }
        SourceTypeBinding[] sourceTypeBindingArray = this.m_astNode.scope.topLevelTypes;
        int n = this.m_astNode.scope.topLevelTypes.length;
        int n2 = 0;
        while (n2 < n) {
            SourceTypeBinding stb = sourceTypeBindingArray[n2];
            result = this.findTypeInSourceTypeBindingRec((Binding)stb, simpleName);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    protected TypeSpi findTypeInSourceTypeBindingRec(Binding b, String simpleName) {
        if (!(b instanceof SourceTypeBinding)) {
            return null;
        }
        SourceTypeBinding stb = (SourceTypeBinding)b;
        TypeSpi result = this.findTypeBySimpleNameInternal(simpleName, (Scope)stb.scope, this.m_env);
        if (result != null) {
            return result;
        }
        ReferenceBinding[] referenceBindingArray = stb.memberTypes;
        int n = stb.memberTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding mb = referenceBindingArray[n2];
            result = this.findTypeInSourceTypeBindingRec((Binding)mb, simpleName);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    protected TypeSpi findTypeBySimpleNameInternal(String simpleName, Scope scopeForTypeLookup, JavaEnvironmentWithJdt env) {
        TypeBinding type = scopeForTypeLookup.getType(simpleName.toCharArray());
        if (type instanceof MissingTypeBinding || type instanceof ProblemReferenceBinding) {
            return null;
        }
        return SpiWithJdtUtils.bindingToType(env, type);
    }

    @Override
    public String getElementName() {
        if (this.m_fileName == null) {
            char[] array = this.m_astNode.getFileName();
            int i = Math.max(CharOperation.lastIndexOf((char)'/', (char[])array), CharOperation.lastIndexOf((char)'\\', (char[])array));
            this.m_fileName = i >= 0 ? new String(array, i + 1, array.length - i - 1) : new String(array);
        }
        return this.m_fileName;
    }

    @Override
    public TypeSpi getMainType() {
        if (this.m_mainType == null) {
            String mainTypeName = new String(this.m_astNode.getMainTypeName());
            for (TypeSpi typeSpi : this.getTypes()) {
                if (!mainTypeName.equals(typeSpi.getElementName())) continue;
                this.m_mainType = typeSpi;
                break;
            }
        }
        return this.m_mainType;
    }

    public List<DeclarationTypeWithJdt> getTypes() {
        if (this.m_types != null) {
            return this.m_types;
        }
        TypeDeclaration[] types = this.m_astNode.types;
        if (types == null || types.length < 1) {
            this.m_types = Collections.emptyList();
        } else {
            ArrayList<DeclarationTypeWithJdt> result = new ArrayList<DeclarationTypeWithJdt>(types.length);
            TypeDeclaration[] typeDeclarationArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration td = typeDeclarationArray[n2];
                result.add(this.m_env.createDeclarationType(this, null, td));
                ++n2;
            }
            this.m_types = Collections.unmodifiableList(result);
        }
        return this.m_types;
    }

    public List<DeclarationImportWithJdt> getImports() {
        if (this.m_imports != null) {
            return this.m_imports;
        }
        ImportReference[] imports = this.m_astNode.imports;
        if (imports == null || imports.length < 1) {
            this.m_imports = Collections.emptyList();
        } else {
            ArrayList<DeclarationImportWithJdt> result = new ArrayList<DeclarationImportWithJdt>(imports.length);
            ImportReference[] importReferenceArray = imports;
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                ImportReference imp = importReferenceArray[n2];
                DeclarationImportWithJdt importDeclaration = this.m_env.createDeclarationImport(this, imp);
                result.add(importDeclaration);
                ++n2;
            }
            this.m_imports = Collections.unmodifiableList(result);
        }
        return this.m_imports;
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            this.m_source = this.m_env.getSource(this, this.m_astNode.sourceStart, this.m_astNode.sourceEnd);
        }
        return this.m_source;
    }

    @Override
    public ISourceRange getJavaDoc() {
        if (this.m_javaDocSource == null) {
            Javadoc doc = this.m_astNode.javadoc;
            this.m_javaDocSource = doc != null ? this.m_env.getSource(this, doc.sourceStart, doc.sourceEnd) : (this.m_astNode.currentPackage != null && this.m_astNode.currentPackage.declarationSourceStart > 0 ? this.m_env.getSource(this, 0, this.m_astNode.currentPackage.declarationSourceStart - 1) : ISourceRange.NO_SOURCE);
        }
        return this.m_javaDocSource;
    }
}

