/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.sugar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.sugar.AbstractManagedAnnotation;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;

public class AnnotationQuery<T> {
    private final IType m_containerType;
    private final AnnotatableSpi m_owner;
    private final String m_methodId;
    private boolean m_includeSuperClasses = false;
    private boolean m_includeSuperInterfaces = false;
    private String m_name;
    private Class<AbstractManagedAnnotation> m_managedWrapperType;
    private Predicate<IAnnotation> m_filter;
    private int m_maxResultCount = Integer.MAX_VALUE;

    public AnnotationQuery(IType containerType, AnnotatableSpi owner) {
        this.m_containerType = containerType;
        this.m_owner = owner;
        this.m_methodId = owner instanceof MethodSpi ? SignatureUtils.createMethodIdentifier(((MethodSpi)owner).wrap()) : null;
    }

    public AnnotationQuery<T> withSuperTypes(boolean b) {
        this.m_includeSuperClasses = b;
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public AnnotationQuery<T> withSuperClasses(boolean b) {
        this.m_includeSuperClasses = b;
        return this;
    }

    public AnnotationQuery<T> withSuperInterfaces(boolean b) {
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public AnnotationQuery<T> withName(String fullyQualifiedName) {
        this.m_name = fullyQualifiedName;
        return this;
    }

    public <A extends AbstractManagedAnnotation> AnnotationQuery<A> withManagedWrapper(Class<A> managedWrapperType) {
        this.m_managedWrapperType = managedWrapperType;
        return this;
    }

    public AnnotationQuery<T> withFilter(Predicate<IAnnotation> filter) {
        this.m_filter = filter;
        return this;
    }

    public AnnotationQuery<T> withMaxResultCount(int maxResultCount) {
        this.m_maxResultCount = maxResultCount;
        return this;
    }

    protected boolean accept(IAnnotation a) {
        if (this.m_name != null && !this.m_name.equals(a.name())) {
            return false;
        }
        if (this.m_managedWrapperType != null && !AbstractManagedAnnotation.typeName(this.m_managedWrapperType).equals(a.name())) {
            return false;
        }
        return this.m_filter == null || this.m_filter.test(a);
    }

    protected AnnotatableSpi findOwner(IType type) {
        IField f;
        if (this.m_owner instanceof TypeSpi) {
            return type.unwrap();
        }
        if (this.m_owner instanceof MethodSpi) {
            IMethod m = type.methods().withFilter(new Predicate<IMethod>(){

                @Override
                public boolean test(IMethod element) {
                    return AnnotationQuery.this.m_methodId.equals(SignatureUtils.createMethodIdentifier(element));
                }
            }).first();
            if (m != null) {
                return m.unwrap();
            }
        } else if (this.m_owner instanceof FieldSpi && (f = type.fields().withName(this.m_owner.getElementName()).first()) != null) {
            return f.unwrap();
        }
        return null;
    }

    protected void visitRec(IType type, AnnotatableSpi owner, List<IAnnotation> result, int maxCount, boolean onlyTraverse) {
        if (type == null) {
            return;
        }
        if (!onlyTraverse) {
            if (owner == null) {
                owner = this.findOwner(type);
            }
            if (owner != null) {
                for (AnnotationSpi annotationSpi : owner.getAnnotations()) {
                    IAnnotation a = annotationSpi.wrap();
                    if (!this.accept(a)) continue;
                    result.add(a);
                    if (result.size() < maxCount) continue;
                    return;
                }
            }
        }
        if (this.m_includeSuperClasses || this.m_includeSuperInterfaces) {
            this.visitRec(type.superClass(), null, result, maxCount, !this.m_includeSuperClasses);
            if (result.size() >= maxCount) {
                return;
            }
        }
        if (this.m_includeSuperInterfaces) {
            for (IType iType : type.superInterfaces()) {
                this.visitRec(iType, null, result, maxCount, false);
                if (result.size() < maxCount) continue;
                return;
            }
        }
    }

    public boolean existsAny() {
        return this.first() != null;
    }

    public T first() {
        ArrayList<IAnnotation> result = new ArrayList<IAnnotation>(1);
        this.visitRec(this.m_containerType, this.m_owner, result, 1, false);
        if (result.isEmpty()) {
            return null;
        }
        if (this.m_managedWrapperType != null) {
            return (T)((IAnnotation)result.get(0)).wrap(this.m_managedWrapperType);
        }
        return (T)result.get(0);
    }

    public List<T> list() {
        ArrayList<IAnnotation> result = new ArrayList<IAnnotation>(this.m_owner.getAnnotations().size());
        this.visitRec(this.m_containerType, this.m_owner, result, this.m_maxResultCount, false);
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.m_managedWrapperType != null) {
            ArrayList<AbstractManagedAnnotation> managedList = new ArrayList<AbstractManagedAnnotation>(result.size());
            for (IAnnotation a : result) {
                managedList.add(a.wrap(this.m_managedWrapperType));
            }
            return managedList;
        }
        return result;
    }
}

