/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.method;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.IMethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public final class MethodBodySourceBuilderFactory {
    private MethodBodySourceBuilderFactory() {
    }

    public static ISourceBuilder createAutoGenerated(final IMethodSourceBuilder methodBuilder) {
        return new ISourceBuilder(){

            @Override
            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append(CoreUtils.getCommentAutoGeneratedMethodStub());
                String returnTypeSignature = methodBuilder.getReturnTypeSignature();
                if (!StringUtils.isEmpty((CharSequence)returnTypeSignature) && !"V".equals(returnTypeSignature)) {
                    source.append(lineDelimiter).append("return ").append(CoreUtils.getDefaultValueOf(returnTypeSignature)).append(';');
                }
            }
        };
    }

    public static ISourceBuilder createSuperCall(final IMethodSourceBuilder methodBuilder, final boolean addAutoGeneratedMethodStubComment) {
        return new ISourceBuilder(){

            @Override
            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                String returnTypeSignature;
                boolean isConstructor;
                if (addAutoGeneratedMethodStubComment) {
                    source.append(CoreUtils.getCommentAutoGeneratedMethodStub());
                    source.append(lineDelimiter);
                }
                if (!(isConstructor = StringUtils.isEmpty((CharSequence)(returnTypeSignature = methodBuilder.getReturnTypeSignature()))) && !"V".equals(returnTypeSignature)) {
                    source.append("return ");
                }
                source.append("super");
                if (!isConstructor) {
                    source.append('.');
                    source.append(methodBuilder.getElementName());
                }
                source.append('(');
                List<IMethodParameterSourceBuilder> parameters = methodBuilder.getParameters();
                if (parameters.size() > 0) {
                    IMethodParameterSourceBuilder param = parameters.get(0);
                    source.append(param.getElementName());
                    int i = 1;
                    while (i < parameters.size()) {
                        param = parameters.get(i);
                        source.append(", ");
                        source.append(param.getElementName());
                        ++i;
                    }
                }
                source.append(");");
            }
        };
    }

    public static ISourceBuilder createReturnClassReference(final String typeSignature) {
        return new ISourceBuilder(){

            @Override
            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append("return ").append(validator.useSignature(typeSignature)).append(SuffixConstants.SUFFIX_class).append(';');
            }
        };
    }
}

