/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.codetype;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.model.ScoutAnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.AbstractEntitySourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.field.FieldSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.field.FieldSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.field.IFieldSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class CodeTypeSourceBuilder
extends AbstractEntitySourceBuilder {
    private static final String ID_CONSTANT_NAME = "ID";
    private String m_superTypeSignature;
    private String m_codeTypeIdSignature;
    private String m_classIdValue;
    private ISourceBuilder m_idValueBuilder;

    public CodeTypeSourceBuilder(String elementName, String packageName, IJavaEnvironment env) {
        super(elementName, packageName, env);
    }

    public void setup() {
        this.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)this));
        TypeSourceBuilder codeTypeBuilder = new TypeSourceBuilder(this.getEntityName());
        codeTypeBuilder.setComment(CommentSourceBuilderFactory.createDefaultTypeComment((ITypeSourceBuilder)codeTypeBuilder));
        codeTypeBuilder.setFlags(1);
        codeTypeBuilder.setSuperTypeSignature(this.getSuperTypeSignature());
        if (StringUtils.isNotBlank((CharSequence)this.getClassIdValue())) {
            codeTypeBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createClassId(this.getClassIdValue()));
        }
        codeTypeBuilder.addField(FieldSourceBuilderFactory.createSerialVersionUidBuilder());
        codeTypeBuilder.addField(this.createId());
        IMethodSourceBuilder getId = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)codeTypeBuilder, (String)this.getPackageName(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"getId");
        getId.setBody((ISourceBuilder)new RawSourceBuilder("return ID;"));
        codeTypeBuilder.addMethod(getId);
        this.addType((ITypeSourceBuilder)codeTypeBuilder);
    }

    protected IFieldSourceBuilder createId() {
        FieldSourceBuilder id = new FieldSourceBuilder(ID_CONSTANT_NAME){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                super.createSource(source, lineDelimiter, context, validator);
                if (CodeTypeSourceBuilder.this.getIdValueBuilder() == null) {
                    source.append(CoreUtils.getCommentBlock((String)"set id value"));
                }
            }
        };
        id.setFlags(25);
        id.setSignature(SignatureUtils.unboxToPrimitiveSignature((String)this.getCodeTypeIdSignature()));
        if (this.getIdValueBuilder() != null) {
            id.setValue(this.getIdValueBuilder());
        } else {
            id.setValue((ISourceBuilder)new RawSourceBuilder("null"));
        }
        return id;
    }

    public String getSuperTypeSignature() {
        return this.m_superTypeSignature;
    }

    public void setSuperTypeSignature(String superTypeSignature) {
        this.m_superTypeSignature = superTypeSignature;
    }

    public String getCodeTypeIdSignature() {
        return this.m_codeTypeIdSignature;
    }

    public void setCodeTypeIdSignature(String codeTypeIdSignature) {
        this.m_codeTypeIdSignature = codeTypeIdSignature;
    }

    public ISourceBuilder getIdValueBuilder() {
        return this.m_idValueBuilder;
    }

    public void setIdValueBuilder(ISourceBuilder idValueBuilder) {
        this.m_idValueBuilder = idValueBuilder;
    }

    public String getClassIdValue() {
        return this.m_classIdValue;
    }

    public void setClassIdValue(String classIdValue) {
        this.m_classIdValue = classIdValue;
    }
}

