/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util;

import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.annotation.OrderAnnotation;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CoreScoutUtils {
    private CoreScoutUtils() {
    }

    public static String getArtifactIdOfPom(Document pom) {
        if (pom == null) {
            return null;
        }
        Element artifactIdElement = CoreUtils.getFirstChildElement((Element)pom.getDocumentElement(), (String)"artifactId");
        if (artifactIdElement != null) {
            return artifactIdElement.getTextContent();
        }
        return null;
    }

    public static String getGroupIdOfPom(Document pom) {
        return CoreScoutUtils.getInheritedValueOfPom(pom, "groupId");
    }

    public static String getVersionOfPom(Document pom) {
        return CoreScoutUtils.getInheritedValueOfPom(pom, "version");
    }

    public static String getParentArtifactId(Document pom) {
        if (pom == null) {
            return null;
        }
        Element parentElement = CoreUtils.getFirstChildElement((Element)pom.getDocumentElement(), (String)"parent");
        if (parentElement == null) {
            return null;
        }
        Element artifactId = CoreUtils.getFirstChildElement((Element)parentElement, (String)"artifactId");
        if (artifactId == null) {
            return null;
        }
        return artifactId.getTextContent();
    }

    static String getInheritedValueOfPom(Document pom, String tagName) {
        if (pom == null) {
            return null;
        }
        Element documentElement = pom.getDocumentElement();
        Element directValueElement = CoreUtils.getFirstChildElement((Element)documentElement, (String)tagName);
        if (directValueElement != null) {
            return directValueElement.getTextContent();
        }
        Element parentElement = CoreUtils.getFirstChildElement((Element)documentElement, (String)"parent");
        if (parentElement == null) {
            return null;
        }
        directValueElement = CoreUtils.getFirstChildElement((Element)parentElement, (String)tagName);
        if (directValueElement == null) {
            return null;
        }
        return directValueElement.getTextContent();
    }

    public static double getNewViewOrderValue(IType declaringType, String orderDefinitionType, int pos) {
        IType[] siblings = CoreScoutUtils.findSiblings(declaringType, pos, orderDefinitionType);
        Double orderValueBefore = CoreScoutUtils.getOrderAnnotationValue(siblings[0]);
        Double orderValueAfter = CoreScoutUtils.getOrderAnnotationValue(siblings[1]);
        if (orderValueBefore != null && orderValueAfter == null) {
            double orderValueBeforeAsDouble = orderValueBefore;
            CoreScoutUtils.validateOrderRange(orderValueBeforeAsDouble);
            double v = Math.ceil(orderValueBeforeAsDouble / 1000.0) * 1000.0;
            return v + 1000.0;
        }
        if (orderValueBefore == null && orderValueAfter != null) {
            double orderValueAfterAsDouble = orderValueAfter;
            CoreScoutUtils.validateOrderRange(orderValueAfterAsDouble);
            double v = Math.floor(orderValueAfterAsDouble / 1000.0) * 1000.0;
            if (v > 1000.0) {
                return 1000.0;
            }
            return v - 1000.0;
        }
        if (orderValueBefore != null && orderValueAfter != null) {
            double a = orderValueBefore;
            double b = orderValueAfter;
            CoreScoutUtils.validateOrderRange(a);
            CoreScoutUtils.validateOrderRange(b);
            return CoreScoutUtils.getOrderValueInBetween(a, b);
        }
        return 1000.0;
    }

    private static void validateOrderRange(double order) {
        if (order > 9.876543212345678E16) {
            NumberFormat f = NumberFormat.getNumberInstance(Locale.ENGLISH);
            f.setGroupingUsed(false);
            String orderAsString = f.format(order);
            SdkLog.warning((String)"The @Order value {} is very large and therefore may not be precise enough. It is recommended to use a lower value.", (Object[])new Object[]{orderAsString});
        }
    }

    static Double getOrderAnnotationValue(IType sibling) {
        if (sibling == null) {
            return null;
        }
        return OrderAnnotation.valueOf((IAnnotatable)sibling, false);
    }

    static IType[] findSiblings(IType declaringType, int pos, String orderDefinitionType) {
        IType prev = null;
        for (IType t : declaringType.innerTypes().withInstanceOf(orderDefinitionType).list()) {
            if (Flags.isAbstract((int)t.flags())) continue;
            if (t.source().start() > pos) {
                return new IType[]{prev, t};
            }
            prev = t;
        }
        IType[] iTypeArray = new IType[2];
        iTypeArray[0] = prev;
        return iTypeArray;
    }

    static double getOrderValueInBetween(double a, double b) {
        double low = Math.min(a, b);
        double high = Math.max(a, b);
        double dif = high - low;
        double lowFloor = Math.floor(low);
        double lowCeil = Math.ceil(low);
        double highFloor = Math.floor(high);
        double nextIntLow = Math.min(lowCeil, highFloor);
        double prevIntHigh = Math.max(lowCeil, highFloor);
        if (low % 1000.0 == 0.0 && low + 1000.0 < high) {
            return low + 1000.0;
        }
        if (lowFloor != highFloor && (lowFloor != low && highFloor != high || dif > 1.0)) {
            double intDif = prevIntHigh - nextIntLow;
            if (intDif == 1.0) {
                return prevIntHigh;
            }
            return nextIntLow + Math.floor(intDif / 2.0);
        }
        return low + dif / 2.0;
    }
}

