/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.MissingTypeException;
import org.eclipse.scout.sdk.core.model.api.internal.TypeImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingFieldWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingMethodWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingTypeParameterWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SourcePositionComparator;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class BindingTypeWithJdt
extends AbstractTypeWithJdt {
    private final ReferenceBinding m_binding;
    private final boolean m_isWildcard;
    private PackageSpi m_package;
    private BindingTypeWithJdt m_declaringType;
    private TypeSpi m_superClass;
    private String m_elementName;
    private String m_name;
    private List<TypeSpi> m_memberTypes;
    private List<TypeSpi> m_superInterfaces;
    private List<TypeParameterSpi> m_typeParameters;
    private List<TypeSpi> m_typeArguments;
    private TypeSpi m_originalType;
    private int m_flags;
    private List<BindingAnnotationWithJdt> m_annotations;
    private List<MethodSpi> m_methods;
    private List<FieldSpi> m_fields;
    private AtomicReference<SourceTypeBinding> m_sourceTypeBindingRef;
    private CompilationUnitSpi m_unit;
    private ISourceRange m_source;
    private ISourceRange m_javaDocSource;
    private ISourceRange m_staticInitSource;

    BindingTypeWithJdt(JavaEnvironmentWithJdt env, ReferenceBinding binding, BindingTypeWithJdt declaringType, boolean isWildcard) {
        super(env);
        if (binding == null || binding instanceof MissingTypeBinding || binding instanceof ProblemReferenceBinding) {
            throw new MissingTypeException("" + binding);
        }
        this.m_binding = (ReferenceBinding)Validate.notNull((Object)binding);
        this.m_isWildcard = isWildcard;
        this.m_declaringType = declaringType;
        this.m_flags = -1;
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        return newEnv.findType(this.getName());
    }

    @Override
    protected IType internalCreateApi() {
        return new TypeImplementor(this);
    }

    public ClassScope getInternalClassScope() {
        SourceTypeBinding stb = this.getSourceTypeBinding();
        return stb != null ? stb.scope : null;
    }

    public ReferenceBinding getInternalBinding() {
        return this.m_binding;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public int getArrayDimension() {
        return 0;
    }

    @Override
    public TypeSpi getLeafComponentType() {
        return null;
    }

    @Override
    public CompilationUnitSpi getCompilationUnit() {
        if (this.m_unit == null) {
            CompilationUnitScope cuScope;
            ClassScope scope = this.getInternalClassScope();
            if (scope != null && (cuScope = scope.compilationUnitScope()) != null) {
                this.m_unit = this.m_env.createDeclarationCompilationUnit(cuScope.referenceContext);
            }
            if (this.m_unit == null) {
                BindingTypeWithJdt parent = this.getDeclaringType();
                this.m_unit = parent != null ? parent.getCompilationUnit() : this.m_env.createSyntheticCompilationUnit(this);
            }
        }
        return this.m_unit;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public PackageSpi getPackage() {
        if (this.m_package == null) {
            char[] qualifiedPackageName = this.m_binding.qualifiedPackageName();
            this.m_package = qualifiedPackageName == null || qualifiedPackageName.length < 1 ? this.m_env.createDefaultPackage() : this.m_env.createPackage(new String(qualifiedPackageName));
        }
        return this.m_package;
    }

    @Override
    public String getName() {
        if (this.m_name == null) {
            this.m_name = this.m_binding.compoundName == null ? new String(this.m_binding.sourceName) : CharOperation.toString((char[][])this.m_binding.compoundName);
        }
        return this.m_name;
    }

    @Override
    public String getElementName() {
        if (this.m_elementName == null) {
            this.m_elementName = new String(this.m_binding.sourceName);
        }
        return this.m_elementName;
    }

    @Override
    public List<FieldSpi> getFields() {
        if (this.m_fields != null) {
            return this.m_fields;
        }
        this.getSourceTypeBinding();
        FieldBinding[] fields = this.m_binding.fields();
        if (fields == null || fields.length < 1) {
            this.m_fields = Collections.emptyList();
        } else {
            fields = Arrays.copyOf(fields, fields.length);
            Arrays.sort(fields, new SourcePositionComparator());
            ArrayList<BindingFieldWithJdt> result = new ArrayList<BindingFieldWithJdt>(fields.length);
            FieldBinding[] fieldBindingArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldBinding fd = fieldBindingArray[n2];
                if (!fd.isSynthetic()) {
                    result.add(this.m_env.createBindingField(this, fd));
                }
                ++n2;
            }
            this.m_fields = Collections.unmodifiableList(result);
        }
        return this.m_fields;
    }

    @Override
    public List<MethodSpi> getMethods() {
        if (this.m_methods != null) {
            return this.m_methods;
        }
        this.getSourceTypeBinding();
        MethodBinding[] methods = this.m_binding.methods();
        if (methods == null || methods.length < 1) {
            this.m_methods = Collections.emptyList();
        } else {
            methods = Arrays.copyOf(methods, methods.length);
            Arrays.sort(methods, new SourcePositionComparator());
            ArrayList<BindingMethodWithJdt> result = new ArrayList<BindingMethodWithJdt>(methods.length);
            MethodBinding[] methodBindingArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                MethodBinding a = methodBindingArray[n2];
                if (!((a.modifiers & 0x4000000) != 0 || a.isBridge() || a.isSynthetic() || a.isDefaultAbstract() || a.isConstructor() && a.sourceMethod() != null && a.sourceMethod().bodyStart == 0)) {
                    result.add(this.m_env.createBindingMethod(this, a));
                }
                ++n2;
            }
            this.m_methods = Collections.unmodifiableList(result);
        }
        return this.m_methods;
    }

    @Override
    public List<TypeSpi> getTypes() {
        if (this.m_memberTypes != null) {
            return this.m_memberTypes;
        }
        this.getSourceTypeBinding();
        ReferenceBinding[] memberTypes = this.m_binding.memberTypes();
        if (memberTypes == null || memberTypes.length < 1) {
            this.m_memberTypes = Collections.emptyList();
        } else {
            memberTypes = Arrays.copyOf(memberTypes, memberTypes.length);
            Arrays.sort(memberTypes, new SourcePositionComparator());
            ArrayList<TypeSpi> result = new ArrayList<TypeSpi>(memberTypes.length);
            ReferenceBinding[] referenceBindingArray = memberTypes;
            int n = memberTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding d = referenceBindingArray[n2];
                TypeSpi t = SpiWithJdtUtils.bindingToType(this.m_env, (TypeBinding)d, this);
                result.add(t);
                ++n2;
            }
            this.m_memberTypes = Collections.unmodifiableList(result);
        }
        return this.m_memberTypes;
    }

    @Override
    public BindingTypeWithJdt getDeclaringType() {
        ReferenceBinding enclosingType;
        if (this.m_declaringType == null && (enclosingType = this.m_binding.enclosingType()) != null) {
            this.m_declaringType = new BindingTypeWithJdt(this.m_env, enclosingType, null, false);
        }
        return this.m_declaringType;
    }

    @Override
    public TypeSpi getSuperClass() {
        if (this.m_superClass == null) {
            this.getSourceTypeBinding();
            ReferenceBinding superclass = this.m_binding.superclass();
            if (superclass != null) {
                this.m_superClass = SpiWithJdtUtils.bindingToType(this.m_env, (TypeBinding)superclass);
            }
        }
        return this.m_superClass;
    }

    @Override
    public List<TypeSpi> getSuperInterfaces() {
        if (this.m_superInterfaces != null) {
            return this.m_superInterfaces;
        }
        this.getSourceTypeBinding();
        ReferenceBinding[] superInterfaces = this.m_binding.superInterfaces();
        if (superInterfaces == null || superInterfaces.length < 1) {
            this.m_superInterfaces = Collections.emptyList();
        } else {
            ArrayList<TypeSpi> result = new ArrayList<TypeSpi>(superInterfaces.length);
            ReferenceBinding[] referenceBindingArray = superInterfaces;
            int n = superInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding b = referenceBindingArray[n2];
                TypeSpi t = SpiWithJdtUtils.bindingToType(this.m_env, (TypeBinding)b);
                if (t != null) {
                    result.add(t);
                }
                ++n2;
            }
            this.m_superInterfaces = Collections.unmodifiableList(result);
        }
        return this.m_superInterfaces;
    }

    @Override
    public boolean isWildcardType() {
        return this.m_isWildcard;
    }

    @Override
    public List<TypeSpi> getTypeArguments() {
        if (this.m_typeArguments != null) {
            return this.m_typeArguments;
        }
        this.getSourceTypeBinding();
        if (this.m_binding instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding ptb = (ParameterizedTypeBinding)this.m_binding;
            TypeBinding[] arguments = ptb.arguments;
            if (arguments != null && arguments.length > 0) {
                ArrayList<TypeSpi> result = new ArrayList<TypeSpi>(arguments.length);
                TypeBinding[] typeBindingArray = arguments;
                int n = arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeBinding b = typeBindingArray[n2];
                    TypeSpi type = SpiWithJdtUtils.bindingToType(this.m_env, b);
                    if (type != null) {
                        result.add(type);
                    }
                    ++n2;
                }
                this.m_typeArguments = Collections.unmodifiableList(result);
            }
        }
        if (this.m_typeArguments == null) {
            this.m_typeArguments = Collections.emptyList();
        }
        return this.m_typeArguments;
    }

    protected TypeVariableBinding[] getTypeVariables() {
        ReferenceBinding refType = this.m_binding;
        if (this.m_binding.actualType() != null) {
            refType = this.m_binding.actualType();
        }
        return refType.typeVariables();
    }

    @Override
    public boolean hasTypeParameters() {
        this.getSourceTypeBinding();
        TypeVariableBinding[] typeVariables = this.getTypeVariables();
        return typeVariables != null && typeVariables.length > 0;
    }

    @Override
    public List<TypeParameterSpi> getTypeParameters() {
        if (this.m_typeParameters != null) {
            return this.m_typeParameters;
        }
        this.getSourceTypeBinding();
        TypeVariableBinding[] typeParams = this.getTypeVariables();
        if (typeParams != null && typeParams.length > 0) {
            ArrayList<BindingTypeParameterWithJdt> result = new ArrayList<BindingTypeParameterWithJdt>(typeParams.length);
            int index = 0;
            TypeVariableBinding[] typeVariableBindingArray = typeParams;
            int n = typeParams.length;
            int n2 = 0;
            while (n2 < n) {
                TypeVariableBinding param = typeVariableBindingArray[n2];
                result.add(this.m_env.createBindingTypeParameter(this, param, index));
                ++index;
                ++n2;
            }
            this.m_typeParameters = Collections.unmodifiableList(result);
        } else {
            this.m_typeParameters = Collections.emptyList();
        }
        return this.m_typeParameters;
    }

    @Override
    public TypeSpi getOriginalType() {
        if (this.m_originalType == null) {
            ReferenceBinding ref = this.m_binding.actualType();
            this.m_originalType = ref == null || ref == this.m_binding ? this : SpiWithJdtUtils.bindingToType(this.m_env, (TypeBinding)ref);
        }
        return this.m_originalType;
    }

    public List<BindingAnnotationWithJdt> getAnnotations() {
        if (this.m_annotations != null) {
            return this.m_annotations;
        }
        this.getSourceTypeBinding();
        ReferenceBinding refType = this.m_binding;
        if (this.m_binding.actualType() != null) {
            refType = this.m_binding.actualType();
        }
        this.m_annotations = SpiWithJdtUtils.createBindingAnnotations(this.m_env, this, refType.getAnnotations());
        return this.m_annotations;
    }

    @Override
    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithJdtUtils.getTypeFlags(this.m_binding.modifiers, null, SpiWithJdtUtils.hasDeprecatedAnnotation(this.m_binding.getAnnotations()));
        }
        return this.m_flags;
    }

    protected SourceTypeBinding getSourceTypeBinding() {
        if (this.m_sourceTypeBindingRef == null) {
            SourceTypeBinding stb = null;
            if (this.m_binding instanceof SourceTypeBinding) {
                stb = (SourceTypeBinding)this.m_binding;
                CompilationUnitScope scope = stb.scope.compilationUnitScope();
                if (scope != null) {
                    scope.environment.completeTypeBindings(scope.referenceContext, true);
                }
            }
            this.m_sourceTypeBindingRef = new AtomicReference<SourceTypeBinding>(stb);
        }
        return this.m_sourceTypeBindingRef.get();
    }

    @Override
    public boolean isAnonymous() {
        return this.m_binding.compoundName == null || this.m_binding.compoundName.length < 1;
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            if (this.m_binding instanceof SourceTypeBinding) {
                TypeDeclaration decl = ((SourceTypeBinding)this.m_binding).scope.referenceContext;
                CompilationUnitSpi cu = this.getCompilationUnit();
                this.m_source = this.m_env.getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
            } else {
                this.m_source = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_source;
    }

    @Override
    public ISourceRange getSourceOfStaticInitializer() {
        if (this.m_staticInitSource == null) {
            if (this.m_binding instanceof SourceTypeBinding) {
                TypeDeclaration decl = ((SourceTypeBinding)this.m_binding).scope.referenceContext;
                FieldDeclaration[] fieldDeclarationArray = decl.fields;
                int n = decl.fields.length;
                int n2 = 0;
                while (n2 < n) {
                    FieldDeclaration fieldDecl = fieldDeclarationArray[n2];
                    if (fieldDecl.type == null && fieldDecl.name == null) {
                        CompilationUnitSpi cu = this.getCompilationUnit();
                        this.m_staticInitSource = this.m_env.getSource(cu, fieldDecl.declarationSourceStart, fieldDecl.declarationSourceEnd);
                        break;
                    }
                    ++n2;
                }
            }
            if (this.m_staticInitSource == null) {
                this.m_staticInitSource = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_staticInitSource;
    }

    @Override
    public ISourceRange getJavaDoc() {
        if (this.m_javaDocSource == null) {
            if (this.m_binding instanceof SourceTypeBinding) {
                TypeDeclaration decl = ((SourceTypeBinding)this.m_binding).scope.referenceContext;
                Javadoc doc = decl.javadoc;
                if (doc != null) {
                    CompilationUnitSpi cu = this.getCompilationUnit();
                    this.m_javaDocSource = this.m_env.getSource(cu, doc.sourceStart, doc.sourceEnd);
                }
            }
            if (this.m_javaDocSource == null) {
                this.m_javaDocSource = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_javaDocSource;
    }
}

