/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.AnnotationImplementor;
import org.eclipse.scout.sdk.core.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationAnnotationElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class DeclarationAnnotationWithJdt
extends AbstractJavaElementWithJdt<IAnnotation>
implements AnnotationSpi {
    private final AnnotatableSpi m_owner;
    private final Annotation m_astNode;
    private final TypeBinding m_typeBinding;
    private Map<String, AnnotationElementSpi> m_values;
    private TypeSpi m_type;
    private ISourceRange m_source;

    DeclarationAnnotationWithJdt(JavaEnvironmentWithJdt env, AnnotatableSpi owner, Annotation astNode) {
        super(env);
        this.m_astNode = (Annotation)Validate.notNull((Object)astNode);
        this.m_owner = (AnnotatableSpi)Validate.notNull((Object)owner);
        this.m_typeBinding = this.m_astNode.type.resolveType(SpiWithJdtUtils.classScopeOf(this.m_owner));
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        return null;
    }

    @Override
    protected IAnnotation internalCreateApi() {
        return new AnnotationImplementor(this);
    }

    public Annotation getInternalAstNode() {
        return this.m_astNode;
    }

    @Override
    public TypeSpi getType() {
        if (this.m_type == null) {
            this.m_type = SpiWithJdtUtils.bindingToType(this.m_env, this.m_typeBinding);
        }
        return this.m_type;
    }

    @Override
    public AnnotationElementSpi getValue(String name) {
        return this.getValues().get(name);
    }

    @Override
    public Map<String, AnnotationElementSpi> getValues() {
        if (this.m_values != null) {
            return this.m_values;
        }
        Map<String, MemberValuePair> defaultsMap = SpiWithJdtUtils.getDeclarationAnnotationSyntheticDefaultValues(this.m_env, this.m_typeBinding);
        LinkedHashMap<String, DeclarationAnnotationElementWithJdt> result = new LinkedHashMap<String, DeclarationAnnotationElementWithJdt>(defaultsMap.size());
        for (String name : defaultsMap.keySet()) {
            result.put(name, null);
        }
        MemberValuePair[] memberValuePairs = this.m_astNode.memberValuePairs();
        if (memberValuePairs != null && memberValuePairs.length > 0) {
            MemberValuePair[] memberValuePairArray = memberValuePairs;
            int n = memberValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                MemberValuePair p = memberValuePairArray[n2];
                DeclarationAnnotationElementWithJdt v = this.m_env.createDeclarationAnnotationValue(this, p, false);
                result.put(v.getElementName(), v);
                ++n2;
            }
        }
        for (Map.Entry<String, MemberValuePair> e : defaultsMap.entrySet()) {
            if (result.get(e.getKey()) != null || e.getValue() == null) continue;
            result.put(e.getKey(), this.m_env.createDeclarationAnnotationValue(this, e.getValue(), true));
        }
        this.m_values = Collections.unmodifiableMap(result);
        return this.m_values;
    }

    @Override
    public AnnotatableSpi getOwner() {
        return this.m_owner;
    }

    @Override
    public String getElementName() {
        return this.getType().getElementName();
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            CompilationUnitSpi cu = SpiWithJdtUtils.declaringTypeOf(this).getCompilationUnit();
            Annotation decl = this.m_astNode;
            this.m_source = this.m_env.getSource(cu, decl.sourceStart, decl.declarationSourceEnd);
        }
        return this.m_source;
    }
}

