/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

class SourcePositionComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int UNKNOWN_SOURCE_POS = -1;

    SourcePositionComparator() {
    }

    @Override
    public int compare(Object o1, Object o2) {
        int pos1 = this.getSourcePosition(o1);
        int pos2 = this.getSourcePosition(o2);
        return Integer.compare(pos1, pos2);
    }

    protected int getSourcePosition(Object o) {
        if (o == null) {
            return -1;
        }
        if (o instanceof ReferenceBinding) {
            return this.getSourcePosition((ReferenceBinding)o);
        }
        if (o instanceof MethodBinding) {
            return this.getSourcePosition((MethodBinding)o);
        }
        if (o instanceof FieldBinding) {
            return this.getSourcePosition((FieldBinding)o);
        }
        throw new IllegalArgumentException("unsupported type: " + o.getClass().getName());
    }

    protected int getSourcePosition(ReferenceBinding rb) {
        TypeBinding tb = (TypeBinding)SpiWithJdtUtils.nvl(rb.original(), rb);
        if (tb == null) {
            return -1;
        }
        TypeDeclaration decl = null;
        if (tb instanceof SourceTypeBinding) {
            decl = ((SourceTypeBinding)tb).scope.referenceContext;
        }
        if (decl == null) {
            return -1;
        }
        return decl.declarationSourceStart;
    }

    protected int getSourcePosition(MethodBinding mb) {
        MethodBinding methodBinding = SpiWithJdtUtils.nvl(mb.original(), mb);
        if (methodBinding == null) {
            return -1;
        }
        AbstractMethodDeclaration decl = methodBinding.sourceMethod();
        if (decl == null) {
            return -1;
        }
        return decl.declarationSourceStart;
    }

    protected int getSourcePosition(FieldBinding fb) {
        FieldBinding fieldBinding = SpiWithJdtUtils.nvl(fb.original(), fb);
        if (fieldBinding == null) {
            return -1;
        }
        FieldDeclaration decl = fieldBinding.sourceField();
        if (decl == null) {
            return -1;
        }
        return decl.declarationSourceStart;
    }
}

