/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.compilationunit;

import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitSourceBuilder;

public abstract class AbstractEntitySourceBuilder
extends CompilationUnitSourceBuilder {
    private final IJavaEnvironment m_javaEnvironment;
    private String m_entityName;

    protected AbstractEntitySourceBuilder(String entityName, String packageName, IJavaEnvironment env) {
        super(String.valueOf((String)Validate.notNull((Object)entityName)) + ".java", packageName);
        this.m_entityName = entityName;
        this.m_javaEnvironment = (IJavaEnvironment)Validate.notNull((Object)env);
    }

    protected AbstractEntitySourceBuilder(ICompilationUnit icu) {
        super(icu);
        this.m_javaEnvironment = icu.javaEnvironment();
        IType mainType = icu.mainType();
        if (mainType != null) {
            this.m_entityName = mainType.elementName();
        }
    }

    public abstract void setup();

    public IJavaEnvironment getJavaEnvironment() {
        return this.m_javaEnvironment;
    }

    public String getEntityName() {
        return this.m_entityName;
    }

    public void setEntityName(String newName) {
        this.m_entityName = newName;
        this.setElementName(String.valueOf(newName) + ".java");
    }
}

