/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.type;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.sdk.core.importcollector.IImportCollector;
import org.eclipse.scout.sdk.core.importcollector.WrappedImportCollector;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureDescriptor;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;

public class EnclosingTypeScopedImportCollector
extends WrappedImportCollector {
    private final String m_enclosingQualifier;
    private final Set<String> m_enclosingQualifiers = new HashSet<String>();
    private final Set<String> m_enclosedSimpleNames = new HashSet<String>();

    public EnclosingTypeScopedImportCollector(IImportCollector inner, ITypeSourceBuilder enclosingTypeSrc) {
        super(inner);
        this.m_enclosingQualifier = enclosingTypeSrc.getFullyQualifiedName();
        this.m_enclosingQualifiers.add(this.m_enclosingQualifier);
        for (ITypeSourceBuilder typeSrc : enclosingTypeSrc.getTypes()) {
            this.m_enclosedSimpleNames.add(typeSrc.getElementName());
        }
        IJavaEnvironment env = this.getJavaEnvironment();
        if (env == null) {
            return;
        }
        HashSet<String> superSignatures = new HashSet<String>(enclosingTypeSrc.getInterfaceSignatures().size() + 1);
        superSignatures.addAll(enclosingTypeSrc.getInterfaceSignatures());
        if (enclosingTypeSrc.getSuperTypeSignature() != null) {
            superSignatures.add(enclosingTypeSrc.getSuperTypeSignature());
        }
        for (String sig : superSignatures) {
            String qname = SignatureUtils.toFullyQualifiedName(Signature.getTypeErasure(sig));
            this.m_enclosingQualifiers.add(qname);
            IType t = env.findType(qname);
            if (t == null) continue;
            for (IType s : t.superTypes().list()) {
                String fqnName = s.name();
                if ("java.lang.Object".equals(fqnName)) continue;
                this.m_enclosingQualifiers.add(fqnName);
                for (IType i : s.innerTypes().list()) {
                    this.m_enclosedSimpleNames.add(i.elementName());
                }
            }
        }
    }

    @Override
    public String getQualifier() {
        return this.m_enclosingQualifier;
    }

    @Override
    public String checkCurrentScope(SignatureDescriptor cand) {
        if (this.m_enclosingQualifiers.contains(cand.getQualifier())) {
            return cand.getSimpleName();
        }
        if (this.m_enclosedSimpleNames.contains(cand.getSimpleName())) {
            return cand.getQualifiedName();
        }
        return super.checkCurrentScope(cand);
    }
}

