/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.typeparameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.AbstractJavaElementSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.typeparameter.ITypeParameterSourceBuilder;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class TypeParameterSourceBuilder
extends AbstractJavaElementSourceBuilder
implements ITypeParameterSourceBuilder {
    private final List<String> m_boundsSignatures = new ArrayList<String>();

    public TypeParameterSourceBuilder(ITypeParameter element) {
        super(element);
        for (IType t : element.bounds()) {
            this.addBoundSignature(SignatureUtils.getTypeSignature(t));
        }
    }

    public TypeParameterSourceBuilder(String elementName) {
        super(elementName);
    }

    @Override
    public List<String> getBoundsSignatures() {
        return Collections.unmodifiableList(this.m_boundsSignatures);
    }

    @Override
    public void addBoundSignature(String boundSignature) {
        if (boundSignature != null) {
            this.m_boundsSignatures.add(boundSignature);
        }
    }

    @Override
    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        super.createSource(source, lineDelimiter, context, validator);
        if (StringUtils.isNotBlank((CharSequence)this.getElementName())) {
            source.append(this.getElementName());
        } else if (!this.m_boundsSignatures.isEmpty()) {
            source.append('?');
        }
        if (!this.m_boundsSignatures.isEmpty()) {
            source.append(" extends ");
            for (String sig : this.m_boundsSignatures) {
                source.append(validator.useSignature(sig));
                source.append(" & ");
            }
            source.setLength(source.length() - 3);
        }
    }
}

