/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

public class CompositeObject
implements Comparable<CompositeObject>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final Object[] m_value;
    private final int m_hash;

    public CompositeObject(Object ... a) {
        this.m_value = a != null && a.length == 1 && a[0] instanceof Collection ? ((Collection)a[0]).toArray() : a;
        this.m_hash = Arrays.deepHashCode(this.m_value);
    }

    public static CompositeObject concat(CompositeObject ... objects) {
        int n = 0;
        CompositeObject[] compositeObjectArray = objects;
        int n2 = objects.length;
        int n3 = 0;
        while (n3 < n2) {
            CompositeObject o = compositeObjectArray[n3];
            n += o.m_value != null ? o.m_value.length : 0;
            ++n3;
        }
        Object[] a = new Object[n];
        int pos = 0;
        CompositeObject[] compositeObjectArray2 = objects;
        int n4 = objects.length;
        int n5 = 0;
        while (n5 < n4) {
            int i;
            CompositeObject o = compositeObjectArray2[n5];
            int n6 = i = o.m_value != null ? o.m_value.length : 0;
            if (i > 0) {
                System.arraycopy(o.m_value, 0, a, pos, i);
                pos += i;
            }
            ++n5;
        }
        return new CompositeObject(a);
    }

    public int hashCode() {
        return this.m_hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeObject other = (CompositeObject)obj;
        return Arrays.deepEquals(this.m_value, other.m_value);
    }

    public int getComponentCount() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.length;
    }

    public Object getComponent(int index) {
        return this.m_value[index];
    }

    public Object[] getComponents() {
        return this.m_value;
    }

    @Override
    public int compareTo(CompositeObject o) {
        Object[] me = this.m_value;
        Object[] other = o.m_value;
        if (me == null) {
            return -1;
        }
        if (other == null) {
            return 1;
        }
        int i = 0;
        while (i < me.length && i < other.length) {
            int c = this.compareImpl(me[i], other[i]);
            if (c != 0) {
                return c;
            }
            ++i;
        }
        if (me.length < other.length) {
            return -1;
        }
        if (me.length > other.length) {
            return 1;
        }
        return 0;
    }

    protected int compareImpl(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        return a.toString().compareTo(b.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (this.m_value != null && this.m_value.length > 0) {
            sb.append(String.valueOf(this.m_value[0]));
            int i = 1;
            while (i < this.m_value.length) {
                sb.append(',');
                sb.append(String.valueOf(this.m_value[i]));
                ++i;
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

