/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.dto;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IPropertyBean;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.model.ScoutAnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.IDtoSourceBuilder;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.SortedMemberKeyFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.AnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.IAnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.field.FieldSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.field.IFieldSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.IMethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.MethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.CoreUtils;

public abstract class AbstractDtoTypeSourceBuilder
extends TypeSourceBuilder
implements IDtoSourceBuilder {
    private static final Pattern ENDING_SEMICOLON_PATTERN = Pattern.compile("\\;$");
    private final IType m_modelType;
    private final IJavaEnvironment m_env;
    private final String m_targetPackageName;
    protected static final Predicate<IPropertyBean> DTO_PROPERTY_FILTER = new Predicate<IPropertyBean>(){

        @Override
        public boolean test(IPropertyBean property) {
            boolean isReadMethodDtoRelevant;
            boolean readAndWriteMethodsExist;
            boolean bl = readAndWriteMethodsExist = property.readMethod() != null && property.writeMethod() != null;
            if (!readAndWriteMethodsExist) {
                return false;
            }
            boolean bl2 = isReadMethodDtoRelevant = property.readMethod().annotations().withName("org.eclipse.scout.rt.client.dto.FormData").existsAny() || property.readMethod().annotations().withName("org.eclipse.scout.rt.client.dto.Data").existsAny();
            if (!isReadMethodDtoRelevant) {
                return false;
            }
            return property.writeMethod().annotations().withName("org.eclipse.scout.rt.client.dto.FormData").existsAny() || property.writeMethod().annotations().withName("org.eclipse.scout.rt.client.dto.Data").existsAny();
        }
    };
    protected static final Comparator<IPropertyBean> BEAN_NAME_COMPARATOR = new Comparator<IPropertyBean>(){

        @Override
        public int compare(IPropertyBean p1, IPropertyBean p2) {
            if (p1 == null && p2 == null) {
                return 0;
            }
            if (p1 == null) {
                return 1;
            }
            if (p2 == null) {
                return -1;
            }
            CompositeObject m1c = new CompositeObject(new Object[]{p1.name(), p1});
            CompositeObject m2c = new CompositeObject(new Object[]{p2.name(), p2});
            return m1c.compareTo(m2c);
        }
    };

    public AbstractDtoTypeSourceBuilder(IType modelType, String targetPackageName, String typeName, IJavaEnvironment env) {
        this(modelType, targetPackageName, typeName, env, true);
    }

    public AbstractDtoTypeSourceBuilder(IType modelType, String targetPackageName, String typeName, IJavaEnvironment env, boolean setup) {
        super(typeName);
        this.m_targetPackageName = targetPackageName;
        this.m_modelType = modelType;
        this.m_env = env;
        if (setup) {
            this.setup();
        }
    }

    protected void setup() {
        this.setupBuilder();
        this.createContent();
    }

    protected void setupBuilder() {
        int flags = 1;
        if (Flags.isAbstract((int)this.getModelType().flags())) {
            flags |= 0x400;
        }
        this.setFlags(flags);
        this.setSuperTypeSignature(this.computeSuperTypeSignature());
    }

    protected void createContent() {
        IFieldSourceBuilder serialVersionUidBuilder = FieldSourceBuilderFactory.createSerialVersionUidBuilder();
        this.addSortedField(SortedMemberKeyFactory.createFieldSerialVersionUidKey((IFieldSourceBuilder)serialVersionUidBuilder), serialVersionUidBuilder);
        AbstractDtoTypeSourceBuilder.copyAnnotations((IAnnotatable)this.getModelType(), (ITypeSourceBuilder)this, this.getJavaEnvironment());
        if (this.getModelType().annotations().withName("org.eclipse.scout.rt.platform.Replace").existsAny()) {
            this.addAnnotation(ScoutAnnotationSourceBuilderFactory.createReplace());
        }
    }

    protected abstract String computeSuperTypeSignature();

    protected static void filterAnnotationValues(IAnnotationSourceBuilder builder, IAnnotation a) {
        if ("org.eclipse.scout.rt.platform.classid.ClassId".equals(a.type().name())) {
            String id = (String)a.element("value").value().get(String.class);
            id = String.valueOf(id) + "-formdata";
            builder.putElement("value", CoreUtils.toStringLiteral((String)id));
        }
    }

    protected static void copyAnnotations(IAnnotatable annotationOwner, ITypeSourceBuilder sourceBuilder, IJavaEnvironment env) {
        List annotations = annotationOwner.annotations().list();
        for (IAnnotation a : annotations) {
            boolean mustCopyAnnotation;
            IAnnotation annotation = a;
            IType annotationDeclarationType = annotation.type();
            String elementName = annotationDeclarationType.name();
            boolean bl = mustCopyAnnotation = !"org.eclipse.scout.rt.client.dto.FormData".equals(elementName) && !"org.eclipse.scout.rt.platform.Order".equals(elementName) && !"org.eclipse.scout.rt.client.dto.PageData".equals(elementName) && !"org.eclipse.scout.rt.client.dto.Data".equals(elementName) && AbstractDtoTypeSourceBuilder.isAnnotationDtoRelevant(annotationDeclarationType) && CoreUtils.isOnClasspath((IJavaEnvironment)env, (IType)annotationDeclarationType);
            if (!mustCopyAnnotation) continue;
            AnnotationSourceBuilder asb = new AnnotationSourceBuilder(a);
            AbstractDtoTypeSourceBuilder.filterAnnotationValues((IAnnotationSourceBuilder)asb, a);
            sourceBuilder.addAnnotation((IAnnotationSourceBuilder)asb);
        }
    }

    protected static boolean isAnnotationDtoRelevant(IType annotationType) {
        if (annotationType == null) {
            return false;
        }
        return annotationType.annotations().withName("org.eclipse.scout.rt.platform.annotations.DtoRelevant").existsAny();
    }

    public IType getModelType() {
        return this.m_modelType;
    }

    public String getTargetPackage() {
        return this.m_targetPackageName;
    }

    protected void collectProperties() {
        List beanPropertyDescriptors = CoreUtils.getPropertyBeans((IType)this.getModelType(), DTO_PROPERTY_FILTER, BEAN_NAME_COMPARATOR);
        for (IPropertyBean desc : beanPropertyDescriptors) {
            String beanName = CoreUtils.ensureValidParameterName((String)desc.name());
            String lowerCaseBeanName = CoreUtils.ensureStartWithLowerCase((String)beanName);
            String upperCaseBeanName = CoreUtils.ensureStartWithUpperCase((String)beanName);
            String propName = String.valueOf(upperCaseBeanName) + "Property";
            String resolvedSignature = SignatureUtils.getTypeSignature((IType)desc.type());
            String boxedSignature = SignatureUtils.boxPrimitiveSignature((String)resolvedSignature);
            TypeSourceBuilder propertyTypeBuilder = new TypeSourceBuilder(propName);
            propertyTypeBuilder.setFlags(9);
            String superTypeSig = Signature.createTypeSignature((String)"org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData");
            superTypeSig = ENDING_SEMICOLON_PATTERN.matcher(superTypeSig).replaceAll(String.valueOf('<') + Matcher.quoteReplacement(boxedSignature) + '>' + ';');
            propertyTypeBuilder.setSuperTypeSignature(superTypeSig);
            IFieldSourceBuilder serialVersionUidBuilder = FieldSourceBuilderFactory.createSerialVersionUidBuilder();
            propertyTypeBuilder.addSortedField(SortedMemberKeyFactory.createFieldSerialVersionUidKey((IFieldSourceBuilder)serialVersionUidBuilder), serialVersionUidBuilder);
            this.addSortedType(SortedMemberKeyFactory.createTypeFormDataPropertyKey((ITypeSourceBuilder)propertyTypeBuilder), (ITypeSourceBuilder)propertyTypeBuilder);
            IMethod propertyMethod = desc.readMethod();
            if (propertyMethod == null) {
                propertyMethod = desc.writeMethod();
            }
            if (propertyMethod != null) {
                AbstractDtoTypeSourceBuilder.copyAnnotations((IAnnotatable)propertyMethod, (ITypeSourceBuilder)propertyTypeBuilder, this.getJavaEnvironment());
            }
            MethodSourceBuilder propertyGetterBuilder = new MethodSourceBuilder("get" + propName);
            propertyGetterBuilder.setFlags(1);
            propertyGetterBuilder.setReturnTypeSignature(Signature.createTypeSignature((String)propName, (boolean)false));
            propertyGetterBuilder.setBody((ISourceBuilder)new RawSourceBuilder("return getPropertyByClass(" + propName + SuffixConstants.SUFFIX_class + ");"));
            this.addSortedMethod(SortedMemberKeyFactory.createMethodPropertyKey((IMethodSourceBuilder)propertyGetterBuilder), (IMethodSourceBuilder)propertyGetterBuilder);
            MethodSourceBuilder legacyPropertyGetterBuilder = new MethodSourceBuilder(String.valueOf(CoreUtils.getGetterMethodPrefix((String)resolvedSignature)) + upperCaseBeanName);
            legacyPropertyGetterBuilder.setComment(CommentSourceBuilderFactory.createCustomCommentBuilder((String)("access method for property " + upperCaseBeanName + ".")));
            legacyPropertyGetterBuilder.setFlags(1);
            legacyPropertyGetterBuilder.setReturnTypeSignature(resolvedSignature);
            legacyPropertyGetterBuilder.setBody((ISourceBuilder)new RawSourceBuilder(AbstractDtoTypeSourceBuilder.getLegacyGetterMethodBody(resolvedSignature, propName)));
            this.addSortedMethod(SortedMemberKeyFactory.createMethodPropertyKey((IMethodSourceBuilder)legacyPropertyGetterBuilder), (IMethodSourceBuilder)legacyPropertyGetterBuilder);
            MethodSourceBuilder legacyPropertySetterBuilder = new MethodSourceBuilder("set" + upperCaseBeanName);
            legacyPropertySetterBuilder.setComment(CommentSourceBuilderFactory.createCustomCommentBuilder((String)("access method for property " + upperCaseBeanName + ".")));
            legacyPropertySetterBuilder.setFlags(1);
            legacyPropertySetterBuilder.setReturnTypeSignature("V");
            legacyPropertySetterBuilder.addParameter((IMethodParameterSourceBuilder)new MethodParameterSourceBuilder(lowerCaseBeanName, resolvedSignature));
            legacyPropertySetterBuilder.setBody((ISourceBuilder)new RawSourceBuilder("get" + propName + "().setValue(" + lowerCaseBeanName + ");"));
            this.addSortedMethod(SortedMemberKeyFactory.createMethodPropertyKey((IMethodSourceBuilder)legacyPropertySetterBuilder), (IMethodSourceBuilder)legacyPropertySetterBuilder);
        }
    }

    private static String getLegacyGetterMethodBody(String propertySignature, String propertyName) {
        String suffix = "().getValue()";
        StringBuilder source = new StringBuilder("return get");
        source.append(propertyName).append(suffix);
        if (Signature.getTypeSignatureKind((String)propertySignature) == 2) {
            source.append(" == null ? ");
            source.append(CoreUtils.getDefaultValueOf((String)propertySignature));
            source.append(" : get").append(propertyName).append(suffix);
        }
        source.append(';');
        return source.toString();
    }

    @Override
    public IJavaEnvironment getJavaEnvironment() {
        return this.m_env;
    }
}

