/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.s.annotation.ColumnDataAnnotation;
import org.eclipse.scout.sdk.core.s.annotation.DataAnnotation;
import org.eclipse.scout.sdk.core.s.annotation.DataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.annotation.FormDataAnnotation;
import org.eclipse.scout.sdk.core.s.annotation.FormDataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.AbstractDtoTypeSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.CompositeFormDataTypeSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.table.TableBeanDataSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.table.TableFieldBeanFormDataSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.table.TableRowDataTypeSourceBuilder;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ExpressionSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.AnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.AnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.IAnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkException;

public final class DtoUtils {
    private static final String GENERATED_MSG = "This class is auto generated by the Scout SDK. No manual modifications recommended.";
    private static final String GENERATED_JAVADOC = "<b>NOTE:</b><br>This class is auto generated by the Scout SDK. No manual modifications recommended.";
    private static final Pattern DATA_SUFFIX_PATTERN = Pattern.compile("(PageData|FieldData|Data)$");

    private DtoUtils() {
    }

    public static ColumnDataAnnotation.SdkColumnCommand getSdkColumnCommand(IType type) {
        if (type == null) {
            return null;
        }
        ColumnDataAnnotation.SdkColumnCommand sdkColumnCommand = ColumnDataAnnotation.valueOf((IAnnotatable)type);
        if (sdkColumnCommand == ColumnDataAnnotation.SdkColumnCommand.IGNORE || !type.annotations().withName("org.eclipse.scout.rt.platform.Replace").existsAny()) {
            return sdkColumnCommand;
        }
        IType replacedType = type.superClass();
        if (DtoUtils.getSdkColumnCommand(replacedType) != ColumnDataAnnotation.SdkColumnCommand.IGNORE) {
            return ColumnDataAnnotation.SdkColumnCommand.IGNORE;
        }
        if (sdkColumnCommand == null) {
            return ColumnDataAnnotation.SdkColumnCommand.IGNORE;
        }
        return sdkColumnCommand;
    }

    public static String getColumnValueTypeSignature(IType columnContainer) {
        List resolvedTypeParamValues = CoreUtils.getResolvedTypeParamValueSignature((IType)columnContainer, (String)"org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn", (int)0);
        if (resolvedTypeParamValues.isEmpty()) {
            return null;
        }
        return (String)resolvedTypeParamValues.get(0);
    }

    public static String getRowDataName(String base) {
        return String.valueOf(DATA_SUFFIX_PATTERN.matcher(base).replaceAll("")) + "RowData";
    }

    public static String removeFieldSuffix(String fieldName) {
        if (fieldName.endsWith("Field")) {
            fieldName = fieldName.substring(0, fieldName.length() - "Field".length());
        } else if (fieldName.endsWith("Button")) {
            fieldName = fieldName.substring(0, fieldName.length() - "Button".length());
        } else if (fieldName.endsWith("Column")) {
            fieldName = fieldName.substring(0, fieldName.length() - "Column".length());
        } else if (fieldName.endsWith("Page")) {
            fieldName = fieldName.substring(0, fieldName.length() - "Page".length());
        }
        return fieldName;
    }

    private static IType getFormDataType(IType modelType) {
        IType primaryType = DtoUtils.getFormFieldDataPrimaryTypeRec(modelType);
        if (primaryType == null) {
            return null;
        }
        if (modelType.declaringType() == null) {
            return primaryType;
        }
        String formDataName = DtoUtils.removeFieldSuffix(modelType.elementName());
        if (primaryType.elementName().equals(formDataName)) {
            return primaryType;
        }
        return primaryType.innerTypes().withRecursiveInnerTypes(true).withSimpleName(formDataName).first();
    }

    private static IType getFormFieldDataPrimaryTypeRec(IType recursiveDeclaringType) {
        if (recursiveDeclaringType == null) {
            return null;
        }
        FormDataAnnotationDescriptor formDataAnnotation = DtoUtils.getFormDataAnnotationDescriptor(recursiveDeclaringType);
        if (FormDataAnnotationDescriptor.isIgnore(formDataAnnotation)) {
            return null;
        }
        IType declaringType = recursiveDeclaringType.declaringType();
        if (declaringType == null) {
            if (FormDataAnnotationDescriptor.isCreate(formDataAnnotation) || FormDataAnnotationDescriptor.isSdkCommandUse(formDataAnnotation)) {
                return formDataAnnotation.getFormDataType();
            }
            return null;
        }
        return DtoUtils.getFormFieldDataPrimaryTypeRec(declaringType);
    }

    public static String computeSuperTypeSignatureForFormData(IType modelType, FormDataAnnotationDescriptor formDataAnnotation) {
        IType replacedType;
        IType replacedFormFieldDataType;
        if (modelType.annotations().withName("org.eclipse.scout.rt.platform.Replace").existsAny() && (replacedFormFieldDataType = DtoUtils.getFormDataType(replacedType = modelType.superClass())) != null) {
            return replacedFormFieldDataType.signature();
        }
        return DtoUtils.computeSuperTypeSignatureForFormDataIgnoringReplace(modelType, formDataAnnotation);
    }

    private static String computeSuperTypeSignatureForFormDataIgnoringReplace(IType formField, FormDataAnnotationDescriptor formDataAnnotation) {
        IType genericType;
        IType genericOrdinalDefinitionType;
        IType superType = formDataAnnotation.getSuperType();
        if (formDataAnnotation.getGenericOrdinal() >= 0 && (genericOrdinalDefinitionType = formDataAnnotation.getGenericOrdinalDefinitionType()) != null && superType != null && superType.hasTypeParameters() && (genericType = DtoUtils.computeDtoGenericType(formField, genericOrdinalDefinitionType, formDataAnnotation.getGenericOrdinal())) != null) {
            String genericTypeName = SignatureUtils.toFullyQualifiedName((String)SignatureUtils.getTypeSignature((IType)genericType));
            return Signature.createTypeSignature((String)(String.valueOf(superType.name()) + '<' + genericTypeName + '>'));
        }
        return SignatureUtils.getTypeSignature((IType)superType);
    }

    private static IType computeDtoGenericType(IType contextType, IType annotationOwnerType, int genericOrdinal) {
        if (contextType == null || Object.class.getName().equals(contextType.name()) || annotationOwnerType == null) {
            return null;
        }
        if (annotationOwnerType.typeArguments().size() <= genericOrdinal) {
            int numTypeParams = annotationOwnerType.typeParameters().size();
            if (numTypeParams > genericOrdinal) {
                List params = ((ITypeParameter)annotationOwnerType.typeParameters().get(genericOrdinal)).bounds();
                if (!params.isEmpty()) {
                    return (IType)params.get(0);
                }
                return null;
            }
            throw new SdkException("Invalid genericOrdinal value on class '" + annotationOwnerType.name() + "': " + genericOrdinal + ". This class has only " + numTypeParams + " type parameters.");
        }
        List resolvedTypeParamValue = CoreUtils.getResolvedTypeParamValue((IType)contextType, (IType)annotationOwnerType, (int)genericOrdinal);
        if (resolvedTypeParamValue.isEmpty()) {
            return null;
        }
        return (IType)resolvedTypeParamValue.get(0);
    }

    public static IType findDtoForForm(IType form) {
        if (form == null) {
            return null;
        }
        FormDataAnnotationDescriptor a = DtoUtils.getFormDataAnnotationDescriptor(form);
        return a.getFormDataType();
    }

    public static IType findDtoForPage(IType page) {
        if (page == null) {
            return null;
        }
        DataAnnotationDescriptor anot = DtoUtils.getDataAnnotationDescriptor(page);
        if (anot == null) {
            return null;
        }
        return anot.getDataType();
    }

    public static DataAnnotationDescriptor getDataAnnotationDescriptor(IType type) {
        if (type == null) {
            return null;
        }
        IType dtoType = DtoUtils.getDataAnnotationValue(type);
        if (dtoType == null) {
            return null;
        }
        IType superType = null;
        IType curType = type.superClass();
        while (curType != null) {
            superType = DtoUtils.getDataAnnotationValue(curType);
            if (superType != null) break;
            curType = curType.superClass();
        }
        return new DataAnnotationDescriptor(dtoType, superType, (IAnnotatable)type);
    }

    private static IType getDataAnnotationValue(IType type) {
        IType dataType = DataAnnotation.valueOf((IAnnotatable)type);
        if (dataType != null) {
            return dataType;
        }
        IAnnotation annotation = (IAnnotation)type.annotations().withName("org.eclipse.scout.rt.client.dto.PageData").first();
        if (annotation != null) {
            return (IType)annotation.element("value").value().get(IType.class);
        }
        return null;
    }

    public static FormDataAnnotationDescriptor getFormDataAnnotationDescriptor(IType type) {
        FormDataAnnotationDescriptor anot = new FormDataAnnotationDescriptor();
        if (type.isInstanceOf("org.eclipse.scout.rt.client.extension.ui.form.IFormExtension") || type.isInstanceOf("org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension")) {
            DataAnnotationDescriptor dataAnnotation = DtoUtils.getDataAnnotationDescriptor(type);
            if (dataAnnotation != null) {
                anot.setAnnotationOwner((IAnnotatable)type);
                anot.setDefaultSubtypeSdkCommand(FormDataAnnotation.DefaultSubtypeSdkCommand.CREATE);
                anot.setFormDataType(dataAnnotation.getDataType());
                anot.setGenericOrdinal(-1);
                anot.setSdkCommand(FormDataAnnotation.SdkCommand.CREATE);
                IType superDataType = dataAnnotation.getSuperDataType();
                if (superDataType != null) {
                    anot.setSuperType(superDataType);
                } else {
                    IType t = type.javaEnvironment().findType("org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData");
                    anot.setSuperType(t);
                }
            }
        } else {
            DtoUtils.parseFormDataAnnotationRec(anot, type, true);
        }
        return anot;
    }

    private static void parseFormDataAnnotationRec(FormDataAnnotationDescriptor descriptorToFill, IType type, boolean isOwner) {
        if (type != null) {
            boolean replaceAnnotationPresent = type.annotations().withName("org.eclipse.scout.rt.platform.Replace").existsAny();
            IType superType = type.superClass();
            DtoUtils.parseFormDataAnnotationRec(descriptorToFill, superType, replaceAnnotationPresent);
            for (IType superInterface : type.superInterfaces()) {
                DtoUtils.parseFormDataAnnotationRec(descriptorToFill, superInterface, replaceAnnotationPresent);
            }
            if (replaceAnnotationPresent && superType != null && !superType.annotations().withName("org.eclipse.scout.rt.platform.Replace").existsAny()) {
                IType declaringType = superType.declaringType();
                while (declaringType != null) {
                    FormDataAnnotationDescriptor declaringTypeformDataAnnotation = DtoUtils.getFormDataAnnotationDescriptor(declaringType);
                    if (FormDataAnnotationDescriptor.isIgnore(declaringTypeformDataAnnotation)) {
                        descriptorToFill.setSdkCommand(FormDataAnnotation.SdkCommand.IGNORE);
                        break;
                    }
                    declaringType = declaringType.declaringType();
                }
            }
            boolean cumulativeAttribsOnly = replaceAnnotationPresent && !FormDataAnnotationDescriptor.isIgnore(descriptorToFill) && !type.isInstanceOf("org.eclipse.scout.rt.client.ui.form.IForm");
            DtoUtils.fillFormDataAnnotation((IAnnotatable)type, descriptorToFill, isOwner, cumulativeAttribsOnly);
        }
    }

    private static void fillFormDataAnnotation(IAnnotatable element, FormDataAnnotationDescriptor descriptorToFill, boolean isOwner, boolean cumulativeAttributesOnly) {
        boolean isMemberType;
        FormDataAnnotation formDataAnnotation = (FormDataAnnotation)((Object)element.annotations().withManagedWrapper(FormDataAnnotation.class).first());
        if (formDataAnnotation == null) {
            return;
        }
        IType dtoType = null;
        if (!formDataAnnotation.isValueDefault()) {
            dtoType = formDataAnnotation.value();
        }
        FormDataAnnotation.SdkCommand sdkCommand = null;
        if (!formDataAnnotation.isSdkCommandDefault()) {
            sdkCommand = formDataAnnotation.sdkCommand();
        }
        FormDataAnnotation.DefaultSubtypeSdkCommand subTypeCommand = null;
        if (!formDataAnnotation.isDefaultSubtypeSdkCommandDefault()) {
            subTypeCommand = formDataAnnotation.defaultSubtypeSdkCommand();
        }
        int genericOrdinal = formDataAnnotation.genericOrdinal();
        IType[] interfaceSignatures = formDataAnnotation.interfaces();
        if (!cumulativeAttributesOnly) {
            if (dtoType != null) {
                if (isOwner) {
                    descriptorToFill.setFormDataType(dtoType);
                } else {
                    descriptorToFill.setSuperType(dtoType);
                }
            }
            if (isOwner && sdkCommand != null) {
                descriptorToFill.setSdkCommand(sdkCommand);
            }
            if (subTypeCommand != null) {
                descriptorToFill.setDefaultSubtypeSdkCommand(subTypeCommand);
            }
            if (genericOrdinal > -1) {
                descriptorToFill.setGenericOrdinal(genericOrdinal);
                if (element instanceof IType) {
                    descriptorToFill.setGenericOrdinalDefinitionType((IType)element);
                } else if (element instanceof IMethod) {
                    descriptorToFill.setGenericOrdinalDefinitionType(((IMethod)element).declaringType());
                }
            }
        }
        descriptorToFill.setAnnotationOwner(element);
        if (interfaceSignatures != null && interfaceSignatures.length > 0) {
            descriptorToFill.addInterfaces(interfaceSignatures);
        }
        boolean bl = isMemberType = element instanceof IType && ((IType)element).declaringType() != null;
        if (isOwner && sdkCommand == FormDataAnnotation.SdkCommand.USE && dtoType != null && isMemberType) {
            descriptorToFill.setSuperType(dtoType);
            descriptorToFill.setFormDataType(null);
            descriptorToFill.setSdkCommand(FormDataAnnotation.SdkCommand.CREATE);
        }
        if (element instanceof IMethod && descriptorToFill.getSdkCommand() == null) {
            descriptorToFill.setSdkCommand(FormDataAnnotation.SdkCommand.CREATE);
        }
    }

    public static void addFormDataAdditionalInterfaces(FormDataAnnotationDescriptor formDataAnnotation, ITypeSourceBuilder sourceBuilder, IJavaEnvironment context) {
        Set<IType> interfaces = formDataAnnotation.getInterfaceSignatures();
        if (interfaces.isEmpty()) {
            return;
        }
        HashSet allSuperInterfaces = new HashSet();
        for (IType ifcType : interfaces) {
            if (!CoreUtils.isOnClasspath((IJavaEnvironment)context, (IType)ifcType)) continue;
            sourceBuilder.addInterfaceSignature(SignatureUtils.getTypeSignature((IType)ifcType));
            allSuperInterfaces.addAll(ifcType.superTypes().withSuperClasses(false).list());
        }
        HashSet<String> allSuperInterfaceMethods = new HashSet<String>();
        for (IType t : allSuperInterfaces) {
            for (IMethod m : t.methods().list()) {
                allSuperInterfaceMethods.add(SignatureUtils.createMethodIdentifier((IMethod)m));
            }
        }
        for (IMethodSourceBuilder msb : sourceBuilder.getMethods()) {
            if (!allSuperInterfaceMethods.contains(msb.getMethodIdentifier())) continue;
            msb.addAnnotation(AnnotationSourceBuilderFactory.createOverride());
        }
    }

    public static ICompilationUnitSourceBuilder createTableRowDataBuilder(IType modelType, DataAnnotationDescriptor dataAnnotation, IJavaEnvironment sharedEnv) {
        if (dataAnnotation == null) {
            return null;
        }
        Validate.notNull((Object)modelType);
        Validate.notNull((Object)sharedEnv);
        String targetPackage = Signature.getQualifier((String)dataAnnotation.getDataType().name());
        String dataTypeName = dataAnnotation.getDataType().elementName();
        TableRowDataTypeSourceBuilder rowDataTypeSrc = new TableRowDataTypeSourceBuilder(dataTypeName, modelType, modelType, sharedEnv);
        rowDataTypeSrc.setComment(CommentSourceBuilderFactory.createCustomCommentBuilder((String)GENERATED_JAVADOC));
        DtoUtils.addDtoExtendsAnnotation((ITypeSourceBuilder)rowDataTypeSrc, dataAnnotation.getAnnotationHolder());
        rowDataTypeSrc.addAnnotation(AnnotationSourceBuilderFactory.createGenerated((String)modelType.name(), (String)GENERATED_MSG));
        CompilationUnitSourceBuilder cuSrc = new CompilationUnitSourceBuilder(String.valueOf(rowDataTypeSrc.getElementName()) + ".java", targetPackage);
        cuSrc.addType((ITypeSourceBuilder)rowDataTypeSrc);
        cuSrc.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)cuSrc));
        return cuSrc;
    }

    public static ICompilationUnitSourceBuilder createPageDataBuilder(IType modelType, DataAnnotationDescriptor dataAnnotation, IJavaEnvironment sharedEnv) {
        if (dataAnnotation == null) {
            return null;
        }
        Validate.notNull((Object)modelType);
        Validate.notNull((Object)sharedEnv);
        String targetPackage = Signature.getQualifier((String)dataAnnotation.getDataType().name());
        TableBeanDataSourceBuilder pageDataTypeSrc = new TableBeanDataSourceBuilder(modelType, dataAnnotation, targetPackage, dataAnnotation.getDataType().elementName(), sharedEnv);
        pageDataTypeSrc.setComment(CommentSourceBuilderFactory.createCustomCommentBuilder((String)GENERATED_JAVADOC));
        pageDataTypeSrc.addAnnotation(AnnotationSourceBuilderFactory.createGenerated((String)modelType.name(), (String)GENERATED_MSG));
        CompilationUnitSourceBuilder cuSrc = new CompilationUnitSourceBuilder(String.valueOf(pageDataTypeSrc.getElementName()) + ".java", targetPackage);
        cuSrc.addType((ITypeSourceBuilder)pageDataTypeSrc);
        cuSrc.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)cuSrc));
        return cuSrc;
    }

    public static ICompilationUnitSourceBuilder createFormDataBuilder(IType modelType, FormDataAnnotationDescriptor formDataAnnotation, IJavaEnvironment sharedEnv) {
        if (!FormDataAnnotationDescriptor.isCreate(formDataAnnotation)) {
            return null;
        }
        Validate.notNull((Object)modelType);
        Validate.notNull((Object)sharedEnv);
        String targetPackage = Signature.getQualifier((String)formDataAnnotation.getFormDataType().name());
        IType superType = formDataAnnotation.getSuperType();
        if (superType != null) {
            AbstractDtoTypeSourceBuilder formDataTypeSrc = null;
            formDataTypeSrc = superType.isInstanceOf("org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData") ? new TableFieldBeanFormDataSourceBuilder(modelType, formDataAnnotation, targetPackage, formDataAnnotation.getFormDataType().elementName(), sharedEnv) : new CompositeFormDataTypeSourceBuilder(modelType, formDataAnnotation, targetPackage, formDataAnnotation.getFormDataType().elementName(), sharedEnv);
            formDataTypeSrc.setComment(CommentSourceBuilderFactory.createCustomCommentBuilder((String)GENERATED_JAVADOC));
            DtoUtils.addDtoExtendsAnnotation((ITypeSourceBuilder)formDataTypeSrc, formDataAnnotation.getAnnotationOwner());
            formDataTypeSrc.addAnnotation(AnnotationSourceBuilderFactory.createGenerated((String)modelType.name(), (String)GENERATED_MSG));
            DtoUtils.addFormDataAdditionalInterfaces(formDataAnnotation, (ITypeSourceBuilder)formDataTypeSrc, sharedEnv);
            CompilationUnitSourceBuilder cuSrc = new CompilationUnitSourceBuilder(String.valueOf(formDataTypeSrc.getElementName()) + ".java", targetPackage);
            cuSrc.addType((ITypeSourceBuilder)formDataTypeSrc);
            cuSrc.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)cuSrc));
            return cuSrc;
        }
        return null;
    }

    public static void addDtoExtendsAnnotation(ITypeSourceBuilder target, IAnnotatable extendsAnnotationHolder) {
        AnnotationSourceBuilder extendsAnnotation = DtoUtils.getExtendsAnnotationSourceBuilder(extendsAnnotationHolder);
        if (extendsAnnotation != null) {
            target.addAnnotation((IAnnotationSourceBuilder)extendsAnnotation);
        }
    }

    private static AnnotationSourceBuilder getExtendsAnnotationSourceBuilder(IAnnotatable element) {
        if (!(element instanceof IType)) {
            return null;
        }
        IType extendedType = DtoUtils.getExtendedType((IType)element);
        if (extendedType == null) {
            return null;
        }
        IType primaryType = CoreUtils.getPrimaryType((IType)extendedType);
        IType extendedDto = null;
        if (primaryType.isInstanceOf("org.eclipse.scout.rt.client.ui.form.IForm") || primaryType.isInstanceOf("org.eclipse.scout.rt.client.ui.form.fields.IFormField")) {
            if (extendedType.isInstanceOf("org.eclipse.scout.rt.client.ui.basic.table.ITable") && extendedType.declaringType() != null) {
                IType tableFieldDto = DtoUtils.getFormDataType(extendedType.declaringType());
                extendedDto = DtoUtils.getRowDataFor(tableFieldDto);
            } else {
                extendedDto = DtoUtils.findDtoForForm(primaryType);
            }
        } else if (primaryType.isInstanceOf("org.eclipse.scout.rt.shared.extension.IExtension")) {
            extendedDto = DtoUtils.findDtoForPage(primaryType);
        } else if (primaryType.isInstanceOf("org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable")) {
            IType pageDto = DtoUtils.findDtoForPage(primaryType);
            extendedDto = pageDto.innerTypes().withInstanceOf("org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData").first();
        }
        if (extendedDto == null) {
            return null;
        }
        AnnotationSourceBuilder asb = new AnnotationSourceBuilder("org.eclipse.scout.rt.platform.extension.Extends");
        asb.putElement("value", ExpressionSourceBuilderFactory.createClassLiteral((String)SignatureUtils.getTypeSignature((IType)extendedDto)));
        return asb;
    }

    private static IType getRowDataFor(IType tableDto) {
        if (tableDto == null) {
            return null;
        }
        return tableDto.innerTypes().withInstanceOf("org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData").first();
    }

    private static IType findExtendsAnnotationValue(IType element) {
        IType curType = element;
        while (curType != null) {
            IAnnotationElement value;
            IAnnotation extendsAnnotation = (IAnnotation)curType.annotations().withName("org.eclipse.scout.rt.platform.extension.Extends").first();
            if (extendsAnnotation != null && (value = extendsAnnotation.element("value")) != null && !value.isDefault()) {
                return (IType)value.value().get(IType.class);
            }
            curType = curType.superClass();
        }
        return null;
    }

    public static IType getExtendedType(IType modelType) {
        IType extendsFromDeclaringType;
        List owner;
        IType extendsValue = DtoUtils.findExtendsAnnotationValue(modelType);
        if (extendsValue != null) {
            return extendsValue;
        }
        boolean isExtension = modelType.isInstanceOf("org.eclipse.scout.rt.shared.extension.IExtension");
        if (isExtension && !(owner = CoreUtils.getResolvedTypeParamValue((IType)modelType, (String)"org.eclipse.scout.rt.shared.extension.IExtension", (int)0)).isEmpty()) {
            return (IType)owner.get(0);
        }
        IType declaringType = modelType.declaringType();
        if (declaringType != null && (extendsFromDeclaringType = DtoUtils.getExtendedType(declaringType)) != null) {
            return extendsFromDeclaringType;
        }
        return null;
    }
}

