/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class ListBlock
extends Block {
    private static final String ANY_CHAR = "\\s+(.*+)";
    private static final Pattern startPattern = Pattern.compile("\\s*((?:(?:\\*)|(?:\\.)){1,5}+|-)\\s+(.*+)");
    private static final Pattern leadingBlankPattern = Pattern.compile("^\\s+");
    private int blockLineCount = 0;
    private Matcher matcher;
    private Stack<ListState> listState;
    private boolean blankSeparator;
    private boolean listContinuation;

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.listState = null;
        return this.correspondsToListLine(line, lineOffset);
    }

    private boolean correspondsToListLine(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    protected int processLineContent(String line, int offset) {
        boolean closeItem = true;
        if (this.blockLineCount == 0) {
            this.listState = new Stack();
            Attributes attributes = new Attributes();
            String listSpec = this.matcher.group(1);
            DocumentBuilder.BlockType type = this.calculateType(listSpec);
            offset = this.matcher.start(2);
            this.listState.push(new ListState(listSpec, 1, type));
            this.builder.beginBlock(type, attributes);
            this.adjustLevel(this.matcher, type, listSpec);
        } else {
            if (line.isEmpty()) {
                if (!this.listContinuation) {
                    this.blankSeparator = true;
                }
                return -1;
            }
            if (this.isListContinuation(line)) {
                this.blankSeparator = false;
                this.listContinuation = true;
                closeItem = false;
                return -1;
            }
            Matcher matcher = startPattern.matcher(line);
            if (!matcher.matches()) {
                if (this.blankSeparator) {
                    this.setClosed(true);
                    this.blankSeparator = false;
                    return 0;
                }
                closeItem = false;
                Matcher leadingBlankMatcher = leadingBlankPattern.matcher(line);
                if (leadingBlankMatcher.find()) {
                    offset = leadingBlankMatcher.end();
                }
                this.markupLanguage.emitMarkupText(this.getParser(), this.state, " ");
            } else {
                String listSpec = matcher.group(1);
                DocumentBuilder.BlockType type = this.calculateType(listSpec);
                offset = matcher.start(2);
                this.adjustLevel(matcher, type, listSpec);
            }
            this.blankSeparator = false;
            this.listContinuation = false;
        }
        ++this.blockLineCount;
        ListState listState = this.listState.peek();
        if (closeItem) {
            if (listState.openItem) {
                this.builder.endBlock();
            }
            listState.openItem = true;
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        }
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    private boolean isListContinuation(String line) {
        return "+".equals(line);
    }

    private DocumentBuilder.BlockType calculateType(String listSpec) {
        switch (listSpec.charAt(listSpec.length() - 1)) {
            case '.': {
                return DocumentBuilder.BlockType.NUMERIC_LIST;
            }
        }
        return DocumentBuilder.BlockType.BULLETED_LIST;
    }

    private void adjustLevel(Matcher matcher, DocumentBuilder.BlockType type, String tag) {
        int level = this.listState.size() + 1;
        for (ListState ls : this.listState) {
            if (!ls.tag.equals(tag)) continue;
            level = ls.level;
        }
        ListState prevState = this.listState.peek();
        while (level != prevState.level || prevState.type != type) {
            Attributes blockAttributes;
            if (level > prevState.level) {
                if (!prevState.openItem) {
                    this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
                    prevState.openItem = true;
                }
                blockAttributes = new Attributes();
                this.listState.push(new ListState(tag, prevState.level + 1, type));
                this.builder.beginBlock(type, blockAttributes);
            } else {
                this.closeOne();
                if (this.listState.isEmpty()) {
                    blockAttributes = new Attributes();
                    this.listState.push(new ListState(tag, 1, type));
                    this.builder.beginBlock(type, blockAttributes);
                }
            }
            prevState = this.listState.peek();
        }
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            while (this.listState != null && !this.listState.isEmpty()) {
                this.closeOne();
            }
            this.listState = null;
        }
        super.setClosed(closed);
    }

    private void closeOne() {
        ListState e = this.listState.pop();
        if (e.openItem) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    public boolean beginNesting() {
        return this.listContinuation;
    }

    public int findCloseOffset(String line, int lineOffset) {
        if (line.isEmpty() || this.isListContinuation(line)) {
            return 0;
        }
        return -1;
    }

    public boolean canResume(String line, int lineOffset) {
        return this.listContinuation && this.correspondsToListLine(line, lineOffset);
    }

    private static class ListState {
        int level;
        String tag;
        DocumentBuilder.BlockType type;
        boolean openItem;

        private ListState(String tag, int level, DocumentBuilder.BlockType type) {
            this.tag = tag;
            this.level = level;
            this.type = type;
        }
    }
}

