/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.search.refactor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.TransactionSupport;
import org.eclipse.jubula.client.ui.rcp.actions.TransactionWrapper;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.ReplaceExecTestCaseData;

public class ReplaceTestCaseTransaction
implements IRunnableWithProgress,
TransactionSupport.ITransaction {
    private ReplaceExecTestCaseData m_data;
    private IProgressMonitor m_monitor;
    private Map<String, String> m_guidMap;
    private List<IExecTestCasePO> m_newExecs = new ArrayList<IExecTestCasePO>();

    public ReplaceTestCaseTransaction(ReplaceExecTestCaseData data, Map<String, String> guidMap) {
        this.m_data = data;
        this.m_guidMap = guidMap;
    }

    public Collection<? extends IPersistentObject> getToLock() {
        ArrayList<Object> toLock = new ArrayList<Object>();
        toLock.addAll(this.m_data.getOldExecTestCases());
        HashSet<INodePO> par = new HashSet<INodePO>();
        for (IExecTestCasePO exec : this.m_data.getOldExecTestCases()) {
            par.add(exec.getSpecAncestor());
        }
        toLock.addAll(par);
        toLock.add(this.m_data.getNewSpecTestCase());
        return toLock;
    }

    public Collection<? extends IPersistentObject> getToRefresh() {
        HashSet<INodePO> toRefresh = new HashSet<INodePO>();
        for (IExecTestCasePO exec : this.m_newExecs) {
            toRefresh.add(exec.getSpecAncestor());
        }
        return toRefresh;
    }

    public Collection<? extends IPersistentObject> getToMerge() {
        return this.m_newExecs;
    }

    public void run(EntityManager sess) throws Exception {
        EntityManager main = GeneralStorage.getInstance().getMasterSession();
        for (IExecTestCasePO exec : this.m_data.getOldExecTestCases()) {
            IExecTestCasePO newExec;
            INodePO parent = exec.getParentNode();
            int index = parent.indexOf((INodePO)exec);
            parent = (INodePO)sess.find(parent.getClass(), (Object)parent.getId());
            main.detach((Object)exec);
            exec = (IExecTestCasePO)sess.find(exec.getClass(), (Object)exec.getId());
            parent.removeNode((INodePO)exec);
            if (exec instanceof IEventExecTestCasePO) {
                ISpecTestCasePO spec = (ISpecTestCasePO)parent;
                IEventExecTestCasePO newEventExec = NodeMaker.createEventExecTestCasePO((ISpecTestCasePO)this.m_data.getNewSpecTestCase(), (INodePO)parent);
                IEventExecTestCasePO oldEventExec = (IEventExecTestCasePO)exec;
                newEventExec.setEventType(oldEventExec.getEventType());
                newEventExec.setReentryProp(oldEventExec.getReentryProp());
                newEventExec.setMaxRetries(oldEventExec.getMaxRetries());
                newExec = newEventExec;
                spec.addEventTestCase(newEventExec);
            } else {
                newExec = NodeMaker.createExecTestCasePO((ISpecTestCasePO)this.m_data.getNewSpecTestCase());
                parent.addNode(index, (INodePO)newExec);
            }
            this.copyPrimitiveMembers(exec, newExec);
            this.addParametersFromOldToNewTC(exec, newExec);
            if (exec.getReferencedDataCube() != null && !exec.getReferencedDataCube().equals(exec.getSpecTestCase().getReferencedDataCube())) {
                newExec.setReferencedDataCube(exec.getReferencedDataCube());
            }
            this.addNewCompNamePairs(exec, newExec);
            sess.remove((Object)exec);
            this.m_newExecs.add(newExec);
            this.m_monitor.worked(1);
        }
    }

    private void copyPrimitiveMembers(IExecTestCasePO oldExec, IExecTestCasePO newExec) {
        newExec.setActive(oldExec.isActive());
        newExec.setComment(oldExec.getComment());
        newExec.setDataFile(oldExec.getDataFile());
        newExec.setGenerated(oldExec.isGenerated());
        if (oldExec.getSpecTestCase().getName() != oldExec.getName()) {
            newExec.setName(oldExec.getName());
        }
        newExec.setParentProjectId(oldExec.getParentProjectId());
        newExec.setToolkitLevel(oldExec.getToolkitLevel());
        newExec.setHasReferencedTD(oldExec.getDataManager().equals(oldExec.getSpecTestCase().getDataManager()));
    }

    private void addParametersFromOldToNewTC(IExecTestCasePO oldExec, IExecTestCasePO newExec) {
        if (oldExec.getHasReferencedTD() || oldExec.getReferencedDataCube() != null) {
            return;
        }
        Map<IParamDescriptionPO, IParamDescriptionPO> newOldParamMap = this.m_data.getNewOldParamMap();
        ITDManager tdManager = newExec.getDataManager();
        for (IParamDescriptionPO newParam : newOldParamMap.keySet()) {
            tdManager.addUniqueId(newParam.getUniqueId());
        }
        for (IDataSetPO oldDataSet : oldExec.getDataManager().getDataSets()) {
            ArrayList<String> newRow = new ArrayList<String>(newOldParamMap.size());
            for (IParamDescriptionPO newParam : newOldParamMap.keySet()) {
                IParamDescriptionPO oldParam = newOldParamMap.get(newParam);
                if (oldParam != null) {
                    int column = oldExec.getDataManager().findColumnForParam(oldParam.getUniqueId());
                    String oldTestData = oldDataSet.getValueAt(column);
                    newRow.add(oldTestData);
                    continue;
                }
                newRow.add(this.m_data.getUnmatchedValuesMap().get(newParam));
            }
            tdManager.insertDataSet(PoMaker.createListWrapperPO(newRow), tdManager.getDataSetCount());
        }
    }

    private IExecTestCasePO addNewCompNamePairs(IExecTestCasePO oldExec, IExecTestCasePO newExec) {
        CompNamesBP cNBP = new CompNamesBP();
        List compNamePairs = cNBP.getAllCompNamesPairs(newExec);
        block0: for (ICompNamesPairPO newPseudoPairs : compNamePairs) {
            if (!this.m_guidMap.containsKey(newPseudoPairs.getFirstName())) continue;
            String oldCompName = this.m_guidMap.get(newPseudoPairs.getFirstName());
            List oldCompNamePairs = cNBP.getAllCompNamesPairs(oldExec);
            for (ICompNamesPairPO oldPair : oldCompNamePairs) {
                if (!oldPair.getFirstName().equals(oldCompName)) continue;
                ICompNamesPairPO newPair = PoMaker.createCompNamesPairPO((String)newPseudoPairs.getFirstName(), (String)oldPair.getSecondName(), (String)oldPair.getType());
                newPair.setPropagated(oldPair.isPropagated());
                newExec.addCompNamesPair(newPair);
                continue block0;
            }
        }
        return newExec;
    }

    public void run(IProgressMonitor monitor) {
        this.m_monitor = monitor;
        if (TransactionWrapper.executeOperation(this)) {
            DataEventDispatcher.getInstance().fireProjectLoadedListener(monitor);
        }
    }
}

