/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.commands.IStartAut;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.StartAUTServerMessage;
import org.eclipse.jubula.communication.internal.message.StartAUTServerStateMessage;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartAUTServerCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(StartAUTServerCommand.class);
    private StartAUTServerMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        try {
            this.m_message = (StartAUTServerMessage)message;
        }
        catch (ClassCastException cce) {
            if (log.isErrorEnabled()) {
                log.error("Cannot convert from " + message.getClass().toString() + " to " + this.m_message.getClass().toString(), (Throwable)cce);
            }
            throw cce;
        }
    }

    public Message execute() {
        log.debug("execute() called");
        StartAUTServerStateMessage result = new StartAUTServerStateMessage();
        Map conf = this.m_message.getAutConfiguration();
        result.setAutId(new AutIdentifier((String)conf.get("AUT_ID")));
        try {
            AutStarter.getInstance().getAgent().setStartAutMessage(this.m_message);
            String autToolkit = this.m_message.getAutToolKit();
            String toolkitName = autToolkit.substring(autToolkit.lastIndexOf(46) + 1, autToolkit.lastIndexOf("ToolkitPlugin"));
            String className = "org.eclipse.jubula.autagent.commands.Start" + toolkitName + "AutServerCommand";
            Class<?> autServerClass = Class.forName(className);
            IStartAut autStarter = (IStartAut)autServerClass.newInstance();
            return autStarter.startAut(conf);
        }
        catch (IllegalArgumentException iae) {
            log.error(iae.getLocalizedMessage(), (Throwable)iae);
            result.setReason(2);
            result.setDescription(iae.getMessage());
        }
        catch (NullPointerException npe) {
            log.error(npe.getLocalizedMessage(), (Throwable)npe);
            result.setReason(4);
            result.setDescription(npe.getMessage());
        }
        catch (SecurityException se) {
            log.error(se.getLocalizedMessage(), (Throwable)se);
            result.setReason(5);
            result.setDescription("security violation:" + se.getMessage());
        }
        catch (IOException ioe) {
            log.error("Could not start AUTServer", (Throwable)ioe);
            result.setReason(3);
            result.setDescription(ioe.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            log.error("Could not find class for AUTServer", (Throwable)cnfe);
            result.setReason(12);
            result.setDescription(cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            log.error("could not instantiate class for AUTServer", (Throwable)ie);
            result.setReason(12);
            result.setDescription(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            log.error("could not instantiate class for AUTServer", (Throwable)iae);
            result.setReason(12);
            result.setDescription(iae.getMessage());
        }
        return result;
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + "timeout() called when it shouldn't (no response)");
    }
}

