/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.FixedLengthBytesRefArray;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.SortableBytesRefArray;

public class OfflineSorter {
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long MIN_BUFFER_SIZE_MB = 32L;
    public static final long ABSOLUTE_MIN_SORT_BUFFER_SIZE = 524288L;
    private static final String MIN_BUFFER_SIZE_MSG = "At least 0.5MB RAM buffer is needed";
    public static final int MAX_TEMPFILES = 10;
    private final Directory dir;
    private final int valueLength;
    private final String tempFileNamePrefix;
    private final BufferSize ramBufferSize;
    private final Counter bufferBytesUsed = Counter.newCounter();
    private final SortableBytesRefArray buffer;
    SortInfo sortInfo;
    private int maxTempFiles;
    private final Comparator<BytesRef> comparator;
    public static final Comparator<BytesRef> DEFAULT_COMPARATOR = Comparator.naturalOrder();

    public OfflineSorter(Directory dir, String tempFileNamePrefix) throws IOException {
        this(dir, tempFileNamePrefix, DEFAULT_COMPARATOR, BufferSize.automatic(), 10, -1);
    }

    public OfflineSorter(Directory dir, String tempFileNamePrefix, Comparator<BytesRef> comparator) throws IOException {
        this(dir, tempFileNamePrefix, comparator, BufferSize.automatic(), 10, -1);
    }

    public OfflineSorter(Directory dir, String tempFileNamePrefix, Comparator<BytesRef> comparator, BufferSize ramBufferSize, int maxTempfiles, int valueLength) {
        if ((long)ramBufferSize.bytes < 524288L) {
            throw new IllegalArgumentException("At least 0.5MB RAM buffer is needed: " + ramBufferSize.bytes);
        }
        if (maxTempfiles < 2) {
            throw new IllegalArgumentException("maxTempFiles must be >= 2");
        }
        if (valueLength == -1) {
            this.buffer = new BytesRefArray(this.bufferBytesUsed);
        } else {
            if (valueLength == 0 || valueLength > Short.MAX_VALUE) {
                throw new IllegalArgumentException("valueLength must be 1 .. 32767; got: " + valueLength);
            }
            this.buffer = new FixedLengthBytesRefArray(valueLength);
        }
        this.valueLength = valueLength;
        this.ramBufferSize = ramBufferSize;
        this.maxTempFiles = maxTempfiles;
        this.comparator = comparator;
        this.dir = dir;
        this.tempFileNamePrefix = tempFileNamePrefix;
    }

    public Directory getDirectory() {
        return this.dir;
    }

    public String getTempFileNamePrefix() {
        return this.tempFileNamePrefix;
    }

    /*
     * Loose catch block
     */
    public String sort(String inputFileName) throws IOException {
        this.sortInfo = new SortInfo();
        this.sortInfo.totalTime = System.currentTimeMillis();
        ArrayList<String> segments = new ArrayList<String>();
        int[] levelCounts = new int[1];
        TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(this.dir);
        boolean success = false;
        try {
            try (ByteSequencesReader is = this.getReader(this.dir.openChecksumInput(inputFileName, IOContext.READONCE), inputFileName);){
                String result;
                int lineCount;
                while ((lineCount = this.readPartition(is)) > 0) {
                    segments.add(this.sortPartition(trackingDir));
                    ++this.sortInfo.tempMergeFiles;
                    this.sortInfo.lineCount += lineCount;
                    levelCounts[0] = levelCounts[0] + 1;
                    int mergeLevel = 0;
                    while (levelCounts[mergeLevel] == this.maxTempFiles) {
                        this.mergePartitions(trackingDir, segments);
                        if (mergeLevel + 2 > levelCounts.length) {
                            levelCounts = ArrayUtil.grow(levelCounts, mergeLevel + 2);
                        }
                        int n = mergeLevel + 1;
                        levelCounts[n] = levelCounts[n] + 1;
                        levelCounts[mergeLevel] = 0;
                        ++mergeLevel;
                    }
                }
                while (segments.size() > 1) {
                    this.mergePartitions(trackingDir, segments);
                }
                if (segments.isEmpty()) {
                    try (IndexOutput out = trackingDir.createTempOutput(this.tempFileNamePrefix, "sort", IOContext.DEFAULT);){
                        CodecUtil.writeFooter(out);
                        result = out.getName();
                    }
                } else {
                    result = (String)segments.get(0);
                }
                assert (trackingDir.getCreatedFiles().size() == 1 && trackingDir.getCreatedFiles().contains(result));
                this.sortInfo.totalTime = System.currentTimeMillis() - this.sortInfo.totalTime;
                CodecUtil.checkFooter(is.in);
                success = true;
                String string = result;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!success) {
                IOUtils.deleteFilesIgnoringExceptions((Directory)trackingDir, trackingDir.getCreatedFiles());
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected String sortPartition(TrackingDirectoryWrapper trackingDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void verifyChecksum(Throwable priorException, ByteSequencesReader reader) throws IOException {
        try (ChecksumIndexInput in = this.dir.openChecksumInput(reader.name, IOContext.READONCE);){
            CodecUtil.checkFooter(in, priorException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergePartitions(Directory trackingDir, List<String> segments) throws IOException {
        long start = System.currentTimeMillis();
        List<String> segmentsToMerge = segments.size() > this.maxTempFiles ? segments.subList(segments.size() - this.maxTempFiles, segments.size()) : segments;
        PriorityQueue<FileAndTop> queue = new PriorityQueue<FileAndTop>(segmentsToMerge.size()){

            @Override
            protected boolean lessThan(FileAndTop a, FileAndTop b) {
                return OfflineSorter.this.comparator.compare(a.current, b.current) < 0;
            }
        };
        Closeable[] streams = new ByteSequencesReader[segmentsToMerge.size()];
        String newSegmentName = null;
        try (ByteSequencesWriter writer = this.getWriter(trackingDir.createTempOutput(this.tempFileNamePrefix, "sort", IOContext.DEFAULT));){
            FileAndTop top;
            newSegmentName = writer.out.getName();
            for (int i = 0; i < segmentsToMerge.size(); ++i) {
                streams[i] = this.getReader(this.dir.openChecksumInput(segmentsToMerge.get(i), IOContext.READONCE), segmentsToMerge.get(i));
                BytesRef item = null;
                try {
                    item = ((ByteSequencesReader)streams[i]).next();
                }
                catch (Throwable t) {
                    this.verifyChecksum(t, (ByteSequencesReader)streams[i]);
                }
                assert (item != null);
                queue.insertWithOverflow(new FileAndTop(i, item));
            }
            while ((top = (FileAndTop)queue.top()) != null) {
                writer.write(top.current);
                try {
                    top.current = ((ByteSequencesReader)streams[top.fd]).next();
                }
                catch (Throwable t) {
                    this.verifyChecksum(t, (ByteSequencesReader)streams[top.fd]);
                }
                if (top.current != null) {
                    queue.updateTop();
                    continue;
                }
                queue.pop();
            }
            CodecUtil.writeFooter(writer.out);
            for (Closeable reader : streams) {
                CodecUtil.checkFooter(((ByteSequencesReader)reader).in);
            }
            this.sortInfo.mergeTime += System.currentTimeMillis() - start;
            ++this.sortInfo.mergeRounds;
        }
        finally {
            IOUtils.close(streams);
        }
        IOUtils.deleteFiles(trackingDir, segmentsToMerge);
        segmentsToMerge.clear();
        segments.add(newSegmentName);
        ++this.sortInfo.tempMergeFiles;
    }

    int readPartition(ByteSequencesReader reader) throws IOException {
        long start = System.currentTimeMillis();
        if (this.valueLength != -1) {
            int limit = this.ramBufferSize.bytes / this.valueLength;
            for (int i = 0; i < limit; ++i) {
                BytesRef item = null;
                try {
                    item = reader.next();
                }
                catch (Throwable t) {
                    this.verifyChecksum(t, reader);
                }
                if (item != null) {
                    this.buffer.append(item);
                    continue;
                }
                break;
            }
        } else {
            do {
                BytesRef item = null;
                try {
                    item = reader.next();
                }
                catch (Throwable t) {
                    this.verifyChecksum(t, reader);
                }
                if (item == null) break;
                this.buffer.append(item);
            } while (this.bufferBytesUsed.get() <= (long)this.ramBufferSize.bytes);
        }
        this.sortInfo.readTime += System.currentTimeMillis() - start;
        return this.buffer.size();
    }

    protected ByteSequencesWriter getWriter(IndexOutput out) throws IOException {
        return new ByteSequencesWriter(out);
    }

    protected ByteSequencesReader getReader(ChecksumIndexInput in, String name) throws IOException {
        return new ByteSequencesReader(in, name);
    }

    public Comparator<BytesRef> getComparator() {
        return this.comparator;
    }

    public static final class BufferSize {
        final int bytes;

        private BufferSize(long bytes) {
            if (bytes > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Buffer too large for Java (2047mb max): " + bytes);
            }
            if (bytes < 524288L) {
                throw new IllegalArgumentException("At least 0.5MB RAM buffer is needed: " + bytes);
            }
            this.bytes = (int)bytes;
        }

        public static BufferSize megabytes(long mb) {
            return new BufferSize(mb * 0x100000L);
        }

        public static BufferSize automatic() {
            Runtime rt = Runtime.getRuntime();
            long max = rt.maxMemory();
            long total = rt.totalMemory();
            long free = rt.freeMemory();
            long totalAvailableBytes = max - total + free;
            long sortBufferByteSize = free / 2L;
            long minBufferSizeBytes = 0x2000000L;
            if (sortBufferByteSize < 0x2000000L || totalAvailableBytes > 0x14000000L) {
                sortBufferByteSize = totalAvailableBytes / 2L > 0x2000000L ? totalAvailableBytes / 2L : Math.max(524288L, sortBufferByteSize);
            }
            return new BufferSize(Math.min(Integer.MAX_VALUE, sortBufferByteSize));
        }
    }

    public static class ByteSequencesReader
    implements BytesRefIterator,
    Closeable {
        protected final String name;
        protected final ChecksumIndexInput in;
        protected final long end;
        private final BytesRefBuilder ref = new BytesRefBuilder();

        public ByteSequencesReader(ChecksumIndexInput in, String name) {
            this.in = in;
            this.name = name;
            this.end = in.length() - (long)CodecUtil.footerLength();
        }

        @Override
        public BytesRef next() throws IOException {
            if (this.in.getFilePointer() >= this.end) {
                return null;
            }
            short length = this.in.readShort();
            this.ref.grow(length);
            this.ref.setLength(length);
            this.in.readBytes(this.ref.bytes(), 0, length);
            return this.ref.get();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    public static class ByteSequencesWriter
    implements Closeable {
        protected final IndexOutput out;

        public ByteSequencesWriter(IndexOutput out) {
            this.out = out;
        }

        public final void write(BytesRef ref) throws IOException {
            assert (ref != null);
            this.write(ref.bytes, ref.offset, ref.length);
        }

        public final void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            assert (bytes != null);
            assert (off >= 0 && off + len <= bytes.length);
            assert (len >= 0);
            if (len > Short.MAX_VALUE) {
                throw new IllegalArgumentException("len must be <= 32767; got " + len);
            }
            this.out.writeShort((short)len);
            this.out.writeBytes(bytes, off, len);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    static class FileAndTop {
        final int fd;
        BytesRef current;

        FileAndTop(int fd, BytesRef firstLine) {
            this.fd = fd;
            this.current = firstLine;
        }
    }

    public class SortInfo {
        public int tempMergeFiles;
        public int mergeRounds;
        public int lineCount;
        public long mergeTime;
        public long sortTime;
        public long totalTime;
        public long readTime;
        public final long bufferSize;

        public SortInfo() {
            this.bufferSize = ((OfflineSorter)OfflineSorter.this).ramBufferSize.bytes;
        }

        public String toString() {
            return String.format(Locale.ROOT, "time=%.2f sec. total (%.2f reading, %.2f sorting, %.2f merging), lines=%d, temp files=%d, merges=%d, soft ram limit=%.2f MB", (double)this.totalTime / 1000.0, (double)this.readTime / 1000.0, (double)this.sortTime / 1000.0, (double)this.mergeTime / 1000.0, this.lineCount, this.tempMergeFiles, this.mergeRounds, (double)this.bufferSize / 1048576.0);
        }
    }
}

