/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils.generator;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import org.eclipse.jubula.tools.internal.xml.businessmodell.AbstractComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ComponentClass;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ParamValueSet;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Property;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ValueSetElement;
import org.eclipse.jubula.tools.internal.xml.businessprocess.ConfigVersion;
import org.eclipse.jubula.tools.internal.xml.businessprocess.XStreamXmlAttributeConverter;

public class XStreamGenerator {
    private XStreamGenerator() {
    }

    public static XStream createXStream() {
        XStream stream = new XStream();
        XStreamGenerator.registerConverter(stream);
        stream.alias("compSystem", CompSystem.class);
        stream.aliasField("configVersion", CompSystem.class, "m_configVersion");
        stream.addImplicitCollection(CompSystem.class, "m_concreteComponents", "toolkitComponent", ConcreteComponent.class);
        stream.addImplicitCollection(CompSystem.class, "m_concreteComponents", "concreteComponent", ConcreteComponent.class);
        stream.addImplicitCollection(CompSystem.class, "m_abstractComponents", "abstractComponent", AbstractComponent.class);
        stream.alias("configVersion", ConfigVersion.class);
        stream.aliasField("majorVersion", ConfigVersion.class, "m_majorV");
        stream.aliasField("minorVersion", ConfigVersion.class, "m_minorV");
        stream.aliasField("majorCustomVersion", ConfigVersion.class, "m_majorCustomV");
        stream.aliasField("minorCustomVersion", ConfigVersion.class, "m_minorCustomV");
        stream.addImplicitCollection(Component.class, "m_realizedTypes", "realizes", String.class);
        stream.addImplicitCollection(Component.class, "m_extendedTypes", "extends", String.class);
        stream.aliasField("type", Component.class, "m_type");
        stream.aliasField("descriptionKey", Component.class, "m_descriptionKey");
        stream.addImplicitCollection(Component.class, "m_actions", "action", Action.class);
        stream.aliasField("apiMostConcrete", Component.class, "m_apiMostConcrete");
        stream.aliasField("since", Component.class, "m_since");
        stream.alias("abstractComponent", AbstractComponent.class);
        stream.aliasField("type", AbstractComponent.class, "m_type");
        stream.aliasField("visible", AbstractComponent.class, "m_visible");
        stream.aliasField("apiMostConcrete", AbstractComponent.class, "m_apiMostConcrete");
        stream.aliasField("observable", AbstractComponent.class, "m_observable");
        stream.aliasField("deprecated", AbstractComponent.class, "m_deprecated");
        stream.aliasField("since", AbstractComponent.class, "m_since");
        stream.alias("toolkitComponent", ConcreteComponent.class);
        stream.alias("concreteComponent", ConcreteComponent.class);
        stream.aliasField("type", ConcreteComponent.class, "m_type");
        stream.aliasField("testerClass", ConcreteComponent.class, "m_testerClass");
        stream.aliasField("visible", ConcreteComponent.class, "m_visible");
        stream.aliasField("apiMostConcrete", ConcreteComponent.class, "m_apiMostConcrete");
        stream.aliasField("hasDefaultMapping", ConcreteComponent.class, "m_hasDefaultMapping");
        stream.aliasField("observable", ConcreteComponent.class, "m_observable");
        stream.aliasField("deprecated", ConcreteComponent.class, "m_deprecated");
        stream.aliasField("since", ConcreteComponent.class, "m_since");
        stream.aliasField("supported", ConcreteComponent.class, "m_isSupported");
        stream.addImplicitCollection(ConcreteComponent.class, "m_compClass", "componentClass", ComponentClass.class);
        stream.alias("componentClass", ComponentClass.class);
        stream.aliasField("name", ComponentClass.class, "m_name");
        stream.addImplicitCollection(ComponentClass.class, "m_properties", "property", Property.class);
        stream.alias("property", Property.class);
        stream.aliasField("name", Property.class, "m_name");
        stream.aliasField("value", Property.class, "m_value");
        XStreamGenerator.aliasActionClass(stream);
        stream.addImplicitCollection(Action.class, "m_params", "param", Param.class);
        stream.aliasField("name", Param.class, "m_name");
        stream.aliasField("descriptionKey", Param.class, "m_descriptionKey");
        stream.aliasField("type", Param.class, "m_type");
        stream.aliasField("defaultValue", Param.class, "m_defaultValue");
        stream.aliasField("valueSet", Param.class, "m_valueSet");
        stream.aliasField("optional", Param.class, "m_optional");
        stream.alias("valueSet", ParamValueSet.class);
        stream.aliasField("valueSet", ParamValueSet.class, "m_valueSet");
        stream.aliasField("combinable", ParamValueSet.class, "m_isCombinable");
        stream.addImplicitCollection(ParamValueSet.class, "m_valueSet", "element", ValueSetElement.class);
        stream.alias("element", ValueSetElement.class);
        stream.aliasField("value", ValueSetElement.class, "m_value");
        stream.aliasField("name", ValueSetElement.class, "m_name");
        return stream;
    }

    private static void registerConverter(XStream stream) {
        stream.registerConverter((Converter)XStreamXmlAttributeConverter.create(stream, Component.class, new String[]{"m_type", "m_descriptionKey", "m_visible", "m_observable", "m_deprecated", "m_since", "m_apiMostConcrete"}));
        stream.registerConverter((Converter)XStreamXmlAttributeConverter.create(stream, AbstractComponent.class, new String[]{"m_type", "m_descriptionKey", "m_visible", "m_observable", "m_deprecated", "m_since", "m_apiMostConcrete"}));
        stream.registerConverter((Converter)XStreamXmlAttributeConverter.create(stream, ConcreteComponent.class, new String[]{"m_type", "m_descriptionKey", "m_visible", "m_observable", "m_deprecated", "m_hasDefaultMapping", "m_since", "m_isSupported", "m_apiMostConcrete"}));
        stream.registerConverter((Converter)XStreamXmlAttributeConverter.create(stream, Action.class, new String[]{"m_name", "m_descriptionKey", "m_clientAction", "m_apiAction", "m_deprecated", "m_since"}));
        stream.registerConverter((Converter)XStreamXmlAttributeConverter.create(stream, Param.class, new String[]{"m_name", "m_descriptionKey", "m_optional"}));
        stream.registerConverter((Converter)XStreamXmlAttributeConverter.create(stream, ParamValueSet.class, "m_isCombinable"));
        stream.registerConverter((Converter)XStreamXmlAttributeConverter.create(stream, ValueSetElement.class, new String[]{"m_name", "m_value"}));
        stream.registerConverter((Converter)XStreamXmlAttributeConverter.create(stream, ConfigVersion.class, new String[]{"m_majorV", "m_minorV", "m_majorCustomV", "m_minorCustomV"}));
        stream.registerConverter((Converter)XStreamXmlAttributeConverter.create(stream, ComponentClass.class, "m_name"));
        stream.registerConverter((Converter)XStreamXmlAttributeConverter.create(stream, Property.class, new String[]{"m_name", "m_value"}));
    }

    private static void aliasActionClass(XStream stream) {
        stream.aliasField("name", Action.class, "m_name");
        stream.aliasField("descriptionKey", Action.class, "m_descriptionKey");
        stream.aliasField("method", Action.class, "m_method");
        stream.aliasField("deprecated", Action.class, "m_deprecated");
        stream.aliasField("postExecutionCommand", Action.class, "m_postExecutionCommand");
        stream.aliasField("clientAction", Action.class, "m_clientAction");
        stream.aliasField("apiAction", Action.class, "m_apiAction");
        stream.aliasField("since", Action.class, "m_since");
    }
}

