/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.properties;

import javax.persistence.EntityNotFoundException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedIntText;
import org.eclipse.jubula.tools.internal.exception.JBFatalAbortException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class AbstractProjectPropertyPage
extends PropertyPage {
    private EditSupport m_editSupport = null;
    private IProjectPO m_workProject = null;

    public AbstractProjectPropertyPage(EditSupport es) {
        this.m_editSupport = es;
    }

    public AbstractProjectPropertyPage() {
    }

    public static EditSupport createEditSupport() throws PMException {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        EditSupport editSupport = new EditSupport((IPersistentObject)project.getProjectProperties(), null);
        editSupport.lockWorkVersion();
        ProjectNameBP.getInstance().clearCache();
        return editSupport;
    }

    public IProjectPO getProject() {
        if (this.m_workProject == null) {
            try {
                this.m_workProject = this.getEditSupport().getWorkProject();
            }
            catch (PMException e) {
                throw new JBFatalAbortException(Messages.CantLoadProjectInEditSession, (Throwable)e, MessageIDs.E_DATABASE_GENERAL);
            }
        }
        return this.m_workProject;
    }

    protected void refreshProject() throws ProjectDeletedException {
        GeneralStorage storage = GeneralStorage.getInstance();
        try {
            storage.getMasterSession().refresh((Object)storage.getProject());
        }
        catch (EntityNotFoundException entityNotFoundException) {
            storage.reloadMasterSession((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected EditSupport getEditSupport() {
        return this.m_editSupport;
    }

    public void setEditSupport(EditSupport es) {
        this.m_editSupport = es;
    }

    public boolean performCancel() {
        Plugin.stopLongRunning();
        return super.performCancel();
    }

    protected void enableSelectionAndEnablementDependent(Button buttonToSyncTo, Control widgetToEnable) {
        if (buttonToSyncTo.isEnabled()) {
            widgetToEnable.setEnabled(buttonToSyncTo.getSelection());
            if (widgetToEnable instanceof CheckedIntText) {
                if (buttonToSyncTo.getSelection()) {
                    ((CheckedIntText)widgetToEnable).validate();
                } else {
                    widgetToEnable.setBackground(null);
                }
            }
        } else {
            widgetToEnable.setEnabled(false);
        }
    }

    protected Composite createComposite(Composite parent, int numColumns, int alignment, boolean horizontalSpace) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = numColumns;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = alignment;
        compositeData.grabExcessHorizontalSpace = horizontalSpace;
        composite.setLayoutData((Object)compositeData);
        return composite;
    }

    protected void createEmptyLabel(Composite parent) {
        this.createLabel(parent, "");
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    protected void separator(Composite composite, int horSpan) {
        this.createLabel(composite, "");
        Label sep = new Label(composite, 258);
        GridData sepData = new GridData();
        sepData.horizontalAlignment = 4;
        sepData.horizontalSpan = horSpan;
        sep.setLayoutData((Object)sepData);
        this.createLabel(composite, "");
    }
}

