/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.discovery;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.epp.internal.mpc.ui.discovery.ShowFileSupportProposalsJob;
import org.eclipse.epp.mpc.core.model.ISearchResult;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.IMarketplaceServiceLocator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

final class DiscoverFileSupportJob
extends Job {
    private final Display display = Display.getCurrent();
    private final IEditorRegistry editorRegistry;
    private final IEditorDescriptor defaultDescriptor;
    private final String fileName;

    public DiscoverFileSupportJob(IEditorRegistry editorRegistry, IEditorDescriptor defaultDescriptor, String fileName) {
        super(NLS.bind((String)Messages.AskMarketPlaceForFileSupportStrategy_jobName, (Object)DiscoverFileSupportJob.getFileExtensionLabel(fileName)));
        this.editorRegistry = editorRegistry;
        this.defaultDescriptor = defaultDescriptor;
        this.fileName = fileName;
    }

    protected IStatus run(IProgressMonitor monitor) {
        BundleContext bundleContext = MarketplaceClientUiPlugin.getBundleContext();
        ServiceReference locatorReference = bundleContext.getServiceReference(IMarketplaceServiceLocator.class);
        IMarketplaceServiceLocator locator = (IMarketplaceServiceLocator)bundleContext.getService(locatorReference);
        IMarketplaceService marketplaceService = locator.getDefaultMarketplaceService();
        try {
            IStatus iStatus = this.run(marketplaceService, monitor);
            return iStatus;
        }
        finally {
            bundleContext.ungetService(locatorReference);
        }
    }

    private IStatus run(IMarketplaceService marketplaceService, IProgressMonitor monitor) {
        List nodes;
        String fileExtension = DiscoverFileSupportJob.getFileExtension(this.fileName);
        String fileExtensionTag = DiscoverFileSupportJob.getFileExtensionTag(fileExtension);
        try {
            ISearchResult searchResult = marketplaceService.tagged(fileExtensionTag, monitor);
            nodes = searchResult.getNodes();
        }
        catch (CoreException ex) {
            Status status = new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.DiscoverFileSupportJob_discoveryFailed, (Object)DiscoverFileSupportJob.getFileExtensionLabel(this.fileName)), (Throwable)ex);
            MarketplaceClientUi.getLog().log((IStatus)status);
            return Status.CANCEL_STATUS;
        }
        if (nodes.isEmpty()) {
            return Status.OK_STATUS;
        }
        ShowFileSupportProposalsJob openDialog = new ShowFileSupportProposalsJob(this.fileName, nodes, this.editorRegistry, this.defaultDescriptor, this.display);
        openDialog.setPriority(10);
        openDialog.setSystem(true);
        openDialog.schedule();
        return Status.OK_STATUS;
    }

    private static String getFileExtensionTag(String fileExtension) {
        return "fileExtension_" + fileExtension;
    }

    static String getFileExtensionLabel(String fileName) {
        String fileExtension = DiscoverFileSupportJob.getFileExtension(fileName);
        return fileExtension.length() == fileName.length() ? fileName : "*." + fileExtension;
    }

    static String getFileExtension(String fileName) {
        String[] split = fileName.split("\\.");
        return split[split.length - 1];
    }
}

