/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.List;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.utils.AbstractParamValueToken;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class VariableToken
extends AbstractParamValueToken {
    private String m_variableName = null;

    public VariableToken(String s, int pos, String variableName, IParamDescriptionPO desc) {
        super(s, pos, desc);
        this.m_variableName = variableName;
    }

    @Override
    public ParamValueConverter.ConvValidationState validate() {
        ParamValueConverter.ConvValidationState state = ParamValueConverter.ConvValidationState.notSet;
        if (this.getParamDescription() == null || "guidancer.datatype.Variable".equals(this.getParamDescription().getType())) {
            state = ParamValueConverter.ConvValidationState.invalid;
            this.setErrorKey(MessageIDs.E_INVALID_VAR_NAME);
        }
        return state;
    }

    @Override
    public String getGuiString() {
        return this.getValue();
    }

    @Override
    public String getExecutionString(List<ExecObject> stack) throws InvalidDataException {
        String resolvedVar = TestExecution.getInstance().getVariableStore().getValue(this.m_variableName);
        if (resolvedVar == null) {
            throw new InvalidDataException(String.valueOf(Messages.VariableWithName) + " " + this.getValue() + " " + Messages.IsNotResolvable, MessageIDs.E_UNRESOLV_VAR_ERROR);
        }
        return resolvedVar;
    }

    @Override
    public String getModelString() {
        return this.getValue();
    }

    public String getVariableString() {
        return this.m_variableName;
    }
}

