/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.components;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.util.ParentGatherer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomHierarchyComposite
extends Composite
implements IInputSelectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PomHierarchyComposite.class);
    private TreeViewer pomsViewer;
    private List<MavenProject> hierarchy;

    public PomHierarchyComposite(Composite parent, int style) {
        super(parent, style);
        this.build();
    }

    private void build() {
        this.setLayout((Layout)new FillLayout(256));
        this.pomsViewer = new TreeViewer((Composite)this, 0);
        this.pomsViewer.setLabelProvider((IBaseLabelProvider)new DepLabelProvider());
        this.pomsViewer.setContentProvider((IContentProvider)new PomHeirarchyContentProvider());
    }

    public void setEnabled(boolean bool) {
        this.pomsViewer.getTree().setEnabled(bool);
        super.setEnabled(bool);
    }

    public void computeHeirarchy(final IMavenProjectFacade project, IRunnableContext context) {
        try {
            if (context != null) {
                context.run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            PomHierarchyComposite.this.computeHeirarchy(project, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            } else {
                this.computeHeirarchy(project, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            LOG.error("An error occurred building pom heirarchy", (Throwable)e);
        }
    }

    private void computeHeirarchy(IMavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        LinkedList<MavenProject> hierarchy = new LinkedList<MavenProject>();
        hierarchy.addAll(new ParentGatherer(projectFacade.getMavenProject(monitor), projectFacade).getParentHierarchy(monitor));
        this.setHierarchy(hierarchy);
    }

    public void setHierarchy(LinkedList<MavenProject> hierarchy) {
        this.hierarchy = hierarchy;
        this.pomsViewer.setInput(hierarchy);
        this.pomsViewer.expandAll();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.pomsViewer.addSelectionChangedListener(listener);
    }

    public Object getInput() {
        return this.pomsViewer.getInput();
    }

    public ISelection getSelection() {
        return this.pomsViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.pomsViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.pomsViewer.setSelection(selection);
    }

    public List<MavenProject> getHierarchy() {
        return this.hierarchy;
    }

    public MavenProject fromSelection() {
        Object obj;
        ISelection selection = this.pomsViewer.getSelection();
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof MavenProject) {
            return (MavenProject)obj;
        }
        return null;
    }

    public static class DepLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public String getText(Object element) {
            MavenProject project = null;
            if (element instanceof MavenProject) {
                project = (MavenProject)element;
            } else if (element instanceof Object[]) {
                project = (MavenProject)((Object[])element)[0];
            } else {
                return "";
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(String.valueOf(project.getGroupId()) + " : " + project.getArtifactId() + " : " + project.getVersion());
            return buffer.toString();
        }

        public Color getForeground(Object element) {
            if (element instanceof MavenProject) {
                MavenProject project = (MavenProject)element;
                IMavenProjectFacade search = MavenPlugin.getMavenProjectRegistry().getMavenProject(project.getGroupId(), project.getArtifactId(), project.getVersion());
                if (search == null) {
                    return Display.getDefault().getSystemColor(16);
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof MavenProject) {
                MavenProject project = (MavenProject)element;
                IMavenProjectFacade search = MavenPlugin.getMavenProjectRegistry().getMavenProject(project.getGroupId(), project.getArtifactId(), project.getVersion());
                if (search == null) {
                    return MavenImages.getOverlayImage("jar_obj.gif", "lock_ovr.gif", 2);
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }
            return null;
        }
    }

    public static class PomHeirarchyContentProvider
    implements ITreeContentProvider {
        private LinkedList<MavenProject> projects;

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof LinkedList) {
                this.projects = (LinkedList)newInput;
            }
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children.length != 0;
        }

        public Object getParent(Object element) {
            if (element instanceof MavenProject) {
                MavenProject project = (MavenProject)element;
                return project.getParent();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof LinkedList) {
                LinkedList projects = (LinkedList)inputElement;
                if (projects.isEmpty()) {
                    return new Object[0];
                }
                return new Object[]{projects.getLast()};
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof MavenProject) {
                MavenProject parent = (MavenProject)parentElement;
                if (this.projects.size() == 1) {
                    return new Object[0];
                }
                if (this.projects.getFirst().equals((Object)parent)) {
                    return new Object[0];
                }
                ListIterator iter = this.projects.listIterator();
                while (iter.hasNext()) {
                    MavenProject next = (MavenProject)iter.next();
                    if (!next.equals((Object)parent)) continue;
                    iter.previous();
                    MavenProject previous = (MavenProject)iter.previous();
                    return new Object[]{previous};
                }
            }
            return new Object[0];
        }
    }
}

